/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.aksw.faraday_cage.engine.AdjacencyMatrix;
import org.aksw.faraday_cage.engine.ExecutionGraph;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.Parameterized;
import org.aksw.faraday_cage.engine.PluginFactory;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.aksw.faraday_cage.vocabulary.FCAGE;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceRequiredException;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutionGraphGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionGraphGenerator.class);

    ExecutionGraphGenerator() {
    }

    static <T> ExecutionGraph<T> generate(Model configGraph, PluginFactory<? extends ExecutionNode<T>> factory) {
        HashMap executionNodeMap = new HashMap();
        ArrayList executionNodes = new ArrayList();
        Set resources = ModelFactory.createInfModel((Reasoner)ReasonerRegistry.getTransitiveReasoner(), (Model)configGraph).listStatements(null, RDF.type, (RDFNode)null).filterKeep(stmt -> stmt.getObject().asResource().hasProperty(RDFS.subClassOf, (RDFNode)FCAGE.ExecutionNode)).mapWith(Statement::getSubject).toSet();
        resources.forEach(nodeResource -> {
            ExecutionNode node = (ExecutionNode)factory.create((Resource)nodeResource);
            if (node instanceof Parameterized) {
                ValidatableParameterMap parameterMap = ((Parameterized)((Object)node)).createParameterMap();
                parameterMap.populate((Resource)nodeResource);
                parameterMap.init();
                ((Parameterized)((Object)node)).initParameters(parameterMap);
            }
            int i = executionNodes.size();
            executionNodes.add(node);
            executionNodeMap.put(nodeResource, i);
        });
        AdjacencyMatrix adj = new AdjacencyMatrix(executionNodes.size());
        resources.stream().filter(s -> s.hasProperty(FCAGE.hasInput)).forEach(s -> {
            int toNode = (Integer)executionNodeMap.get(s);
            Resource o = s.getProperty(FCAGE.hasInput).getObject().asResource();
            if (o.canAs(RDFList.class)) {
                AtomicInteger i = new AtomicInteger(0);
                ((RDFList)o.as(RDFList.class)).iterator().filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).forEachRemaining(r -> {
                    if (r.isAnon()) {
                        try {
                            int fromPort = r.getProperty(FCAGE.fromPort).getInt();
                            int fromNode = (Integer)executionNodeMap.get(r.getProperty(FCAGE.fromNode).getResource());
                            adj.addEdge(fromNode, fromPort, toNode, i.getAndIncrement());
                        }
                        catch (NumberFormatException | LiteralRequiredException e) {
                            throw new RuntimeException("Error in definition of " + s + "! Invalid value \"" + r.getProperty(FCAGE.fromPort).getObject() + "\" for " + FCAGE.fromPort + ", allowed range is integer literals", e);
                        }
                        catch (ResourceRequiredException e) {
                            throw new RuntimeException("Error in definition of " + s + "! Invalid value \"" + r.getProperty(FCAGE.fromNode).getObject() + "\" for " + FCAGE.fromPort + ", allowed range is resources", e);
                        }
                    } else {
                        adj.addEdge((Integer)executionNodeMap.get(r), 0, (Integer)executionNodeMap.get(s), i.getAndIncrement());
                    }
                });
            } else {
                adj.addEdge((Integer)executionNodeMap.get(o), 0, (Integer)executionNodeMap.get(s), 0);
            }
        });
        return adj.compileCanonicalForm(executionNodes);
    }
}

