/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.faraday_cage.decorator.ExecutionNodeWrapper;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.Parameterized;
import org.aksw.faraday_cage.engine.PluginFactory;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.aksw.faraday_cage.vocabulary.FCAGE;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.pf4j.PluginManager;

public class DecoratedExecutionNodeFactory<U extends ExecutionNode<T>, V extends ExecutionNodeWrapper<U, T>, T>
extends PluginFactory<U> {
    private PluginFactory<V> wrapperFactory;
    private List<Resource> universalWrappers = new ArrayList<Resource>();
    private Map<Resource, List<Resource>> typeWrappers = new HashMap<Resource, List<Resource>>();
    private Map<Resource, List<Resource>> instanceWrappers = new HashMap<Resource, List<Resource>>();
    private List<Resource> types = this.listAvailable();

    DecoratedExecutionNodeFactory(Class<U> clazz, Class<V> clazz2, PluginManager pluginManager, Model configModel) {
        super(clazz, pluginManager, FCAGE.ExecutionNode);
        this.registerWrappers(configModel);
        this.wrapperFactory = new PluginFactory<V>(clazz2, pluginManager, FCAGE.ExecutionNodeWrapper);
    }

    private void registerWrappers(Model configModel) {
        configModel.listStatements(null, FCAGE.decoratedBy, (RDFNode)null).forEachRemaining(stmt -> {
            Resource s = stmt.getSubject();
            RDFNode o = stmt.getObject();
            List wrapperIds = o.canAs(RDFList.class) ? ((RDFList)o.as(RDFList.class)).iterator().filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).toList() : List.of(o.asResource());
            if (s.equals((Object)FCAGE.ExecutionNode)) {
                this.universalWrappers = wrapperIds;
            } else {
                this.registerWrappers(s, wrapperIds);
            }
        });
    }

    private void registerWrappers(Resource executionNode, List<Resource> executionNodeWrapper) {
        (this.types.contains(executionNode) ? this.typeWrappers : this.instanceWrappers).put(executionNode, executionNodeWrapper);
    }

    @Override
    public U getImplementationOf(Resource type) {
        ExecutionNode u = (ExecutionNode)super.getImplementationOf(type);
        return (U)this.wrap(u);
    }

    @Override
    public U create(Resource id) {
        ExecutionNode u = (ExecutionNode)super.create(id);
        return (U)this.wrap(u);
    }

    public PluginFactory<V> getWrapperFactory() {
        return this.wrapperFactory;
    }

    private U wrap(U u) {
        U wrapped = u;
        ArrayList<Resource> wrapperIds = new ArrayList<Resource>(this.universalWrappers);
        if (this.typeWrappers.containsKey(u.getType())) {
            wrapperIds.addAll((Collection<Resource>)this.typeWrappers.get(u.getType()));
        }
        if (this.instanceWrappers.containsKey(u.getId())) {
            wrapperIds.addAll((Collection<Resource>)this.instanceWrappers.get(u.getId()));
        }
        for (Resource wrapperId : wrapperIds) {
            wrapped = this.createWrapper(wrapperId).wrap(wrapped);
        }
        return wrapped;
    }

    private V createWrapper(Resource wrapperId) {
        ExecutionNodeWrapper wrapper = (ExecutionNodeWrapper)this.wrapperFactory.create(wrapperId);
        if (wrapper instanceof Parameterized) {
            ValidatableParameterMap parameterMap = ((Parameterized)((Object)wrapper)).createParameterMap();
            parameterMap.populate(wrapperId);
            parameterMap.init();
            ((Parameterized)((Object)wrapper)).initParameters(parameterMap);
        }
        return (V)wrapper;
    }
}

