/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.aksw.faraday_cage.engine.ExecutionGraph;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.FaradayCageContext;
import org.aksw.faraday_cage.engine.ThreadlocalInheritingCompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledExecutionGraph
implements Runnable {
    private String runId;
    private CompletableFuture trigger;
    private CompletableFuture<Void> joiner;
    private static final Logger logger = LoggerFactory.getLogger(CompiledExecutionGraph.class);

    public static <T> CompiledExecutionGraph of(ExecutionGraph<T> executionGraph) {
        return CompiledExecutionGraph.of(executionGraph, FaradayCageContext.newRunId());
    }

    public static <T> CompiledExecutionGraph of(ExecutionGraph<T> executionGraph, String runId) {
        ThreadlocalInheritingCompletableFuture trigger = new ThreadlocalInheritingCompletableFuture();
        CompletionStage<Object> joiner = ThreadlocalInheritingCompletableFuture.completedFuture(null);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(executionGraph.getSize());
        for (int i = 0; i < executionGraph.getSize(); ++i) {
            CompletionStage<Object> handle;
            ExecutionNode currentNode = executionGraph.getNode(i);
            int[] currentRow = executionGraph.getRow(i);
            int inDegree = currentRow[0];
            int outDegree = currentRow[1];
            currentNode.initDegrees(currentRow[0], currentRow[1]);
            if (inDegree == 0) {
                handle = trigger;
            } else {
                handle = ThreadlocalInheritingCompletableFuture.completedFuture(new ArrayList(inDegree));
                int k = 0;
                while (k < inDegree) {
                    int l2 = k++;
                    handle = handle.thenCombine((CompletionStage)futures.get(currentRow[2 + l2 * 2]), (a, b) -> {
                        a.add(currentNode.deepCopy(b.get(currentRow[2 + l2 * 2 + 1])));
                        return a;
                    });
                }
            }
            CompletionStage currentFuture = handle.thenApplyAsync(l -> {
                logger.info("Executing {}...", (Object)currentNode.getId());
                return currentNode.apply((List)l).stream().map(currentNode::deepCopy).collect(Collectors.toList());
            });
            futures.add(currentFuture);
            joiner = joiner.thenCombine(currentFuture, (a, b) -> null);
        }
        return new CompiledExecutionGraph(runId, trigger, (CompletableFuture)joiner);
    }

    private CompiledExecutionGraph(String runId, CompletableFuture trigger, CompletableFuture joiner) {
        this.runId = runId;
        this.trigger = trigger;
        this.joiner = joiner;
    }

    public String getRunId() {
        return this.runId;
    }

    @Override
    public void run() {
        FaradayCageContext.setRunId(this.runId);
        this.trigger.complete(new ArrayList());
    }

    public void join() {
        this.joiner.join();
        if (this.joiner.isCompletedExceptionally()) {
            try {
                this.joiner.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public void andThen(Runnable r) {
        this.joiner.thenRun(r);
    }

    public CompletableFuture<Void> getCompletionStage() {
        return this.joiner;
    }
}

