/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.io.InputStream;
import java.util.Objects;
import org.aksw.faraday_cage.engine.AbstractExecutionNode;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.Parameterized;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public abstract class AbstractParameterizedExecutionNode<T>
extends AbstractExecutionNode<T>
implements Parameterized {
    private ValidatableParameterMap parameterMap = null;

    @Override
    public void initParameters(ValidatableParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Override
    public final ValidatableParameterMap getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public final boolean isInitialized() {
        return super.isInitialized() && this.parameterMap != null;
    }

    protected static Model getValidationModelFor(Class<?> clazz) {
        InputStream in = ExecutionNode.class.getResourceAsStream("/shacl/" + clazz.getCanonicalName() + ".ttl");
        if (Objects.isNull(in)) {
            return ModelFactory.createDefaultModel();
        }
        return ModelFactory.createDefaultModel().read(in, null, "TURTLE");
    }
}

