/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.engine;

import java.util.List;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.InvalidExecutionGraphException;
import org.apache.jena.rdf.model.Resource;

public abstract class AbstractExecutionNode<T>
implements ExecutionNode<T> {
    private int inDegree = -1;
    private int outDegree = -1;
    private Resource id = null;

    @Override
    public final int getInDegree() {
        return this.inDegree;
    }

    @Override
    public final int getOutDegree() {
        return this.outDegree;
    }

    @Override
    public final void initDegrees(int inDegree, int outDegree) throws InvalidExecutionGraphException {
        ExecutionNode.DegreeBounds degreeBounds = this.getDegreeBounds();
        if (inDegree < degreeBounds.minIn() || inDegree > degreeBounds.maxIn()) {
            throw new InvalidExecutionGraphException("Number of inputs for node " + this.id + " is " + inDegree + ", but must be in [" + degreeBounds.minIn() + ", " + degreeBounds.maxIn() + "]!");
        }
        if (outDegree < degreeBounds.minOut() || outDegree > degreeBounds.maxOut()) {
            throw new InvalidExecutionGraphException("Number of outputs for node " + this.id + " is " + outDegree + ", but must be in [" + degreeBounds.minOut() + ", " + degreeBounds.maxOut() + "]!");
        }
        this.inDegree = inDegree;
        this.outDegree = outDegree;
    }

    @Override
    public final void initPluginId(Resource id) {
        this.id = id;
    }

    @Override
    public final Resource getId() {
        return this.id;
    }

    @Override
    public final List<T> apply(List<T> data) {
        if (!this.isInitialized()) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " must be initialized before calling apply()!");
        }
        return this.safeApply(data);
    }

    @Override
    public boolean isInitialized() {
        return this.getInDegree() >= 0 && this.getOutDegree() >= 0 && this.id != null;
    }

    protected abstract List<T> safeApply(List<T> var1);
}

