/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.parameter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class ParameterMapImpl
implements ParameterMap {
    private boolean initialized = false;
    private Set<Parameter> parameters = new HashSet<Parameter>();
    private Map<Parameter, Object> values = new HashMap<Parameter, Object>();

    public ParameterMapImpl(Parameter ... p) {
        this.parameters.addAll(Arrays.asList(p));
    }

    @Override
    public Set<Parameter> getAllParameters() {
        return this.parameters;
    }

    @Override
    public <T> T getValue(Parameter p, T defaultValue) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("ParameterMap needs to be initialized before usage!");
        }
        try {
            if (this.values.containsKey(p)) {
                return (T)this.values.get(p);
            }
            return defaultValue;
        }
        catch (ClassCastException e) {
            ClassCastException ee = new ClassCastException("Unable to retrieve parameter " + p + " as instance of required type.");
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    public <T> T getValue(Parameter p) throws IllegalStateException {
        return this.getValue(p, null);
    }

    @Override
    public ParameterMap init(Resource r) {
        for (Parameter p : this.parameters) {
            if (r != null && r.hasProperty(p.getProperty())) {
                RDFNode node = r.getProperty(p.getProperty()).getObject();
                this.setValue(p, p.applyDeserialization(node));
            }
            if (!p.isRequired() || this.values.get(p) != null) continue;
            throw new RuntimeException("Required parameter '" + p + "' not defined!");
        }
        this.initialized = true;
        return this;
    }

    @Override
    public ParameterMap setValue(Parameter p, Object o) throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("ParameterMap can not set values after being initialized!");
        }
        this.values.put(p, o);
        return this;
    }
}

