/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.parameter;

import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.StringParameterConversion;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;

public class ParameterImpl
implements Parameter {
    private Property property;
    private boolean required;
    private ParameterConversion conversion;

    public ParameterImpl(String propertyName) {
        this(Vocabulary.property(propertyName), (ParameterConversion)StringParameterConversion.getInstance(), true);
    }

    public ParameterImpl(String propertyName, boolean required) {
        this(Vocabulary.property(propertyName), (ParameterConversion)StringParameterConversion.getInstance(), required);
    }

    public ParameterImpl(String propertyName, ParameterConversion conversion, boolean required) {
        this(Vocabulary.property(propertyName), conversion, required);
    }

    private ParameterImpl(Property property, ParameterConversion conversion, boolean required) {
        this.property = property;
        this.required = required;
        this.conversion = conversion;
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public RDFNode applySerialization(Object object) {
        return this.conversion.toRDF(object);
    }

    @Override
    public Object applyDeserialization(RDFNode node) {
        return this.conversion.fromRDF(node);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public boolean equals(Object o) {
        if (o instanceof Parameter) {
            Parameter p = (Parameter)o;
            return this.getProperty().equals(p.getProperty());
        }
        return false;
    }

    public int hashCode() {
        return this.getProperty().hashCode();
    }

    public String toString() {
        return this.getProperty().toString() + (this.required ? " [required]" : "");
    }
}

