/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

public class Vocabulary {
    private static Model vocabModel = ModelFactory.createDefaultModel();
    private static String uri = "http://aksw.org/faraday_cage/#";

    public static Property implementedIn() {
        return Vocabulary.property("implementedIn");
    }

    public static Property hasInput() {
        return Vocabulary.property("hasInput");
    }

    public static Property hasOutput() {
        return Vocabulary.property("hasOutput");
    }

    public static Property toNode() {
        return Vocabulary.property("toNode");
    }

    public static Property toPort() {
        return Vocabulary.property("toPort");
    }

    public static Property property(String s) {
        if (s.contains("http://") || s.contains("https://") || s.contains(":") && vocabModel.getNsPrefixMap().containsKey(s.substring(0, s.indexOf(":")))) {
            return vocabModel.createProperty(s);
        }
        return vocabModel.createProperty(Vocabulary.getURI() + s);
    }

    public static Resource resource(String s) {
        if (s.contains("http://") || s.contains("https://") || s.contains(":") && vocabModel.getNsPrefixMap().containsKey(s.substring(0, s.indexOf(":")))) {
            return vocabModel.createResource(s);
        }
        return vocabModel.createResource(Vocabulary.getURI() + s);
    }

    public static String getURI() {
        return uri;
    }

    public static void setDefaultURI(String uri) {
        Vocabulary.uri = uri;
    }

    public static void addNSPrefix(String prefix, String expansion) {
        vocabModel.setNsPrefix(prefix, expansion);
    }
}

