/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.aksw.faraday_cage.ExecutionGraph;
import org.aksw.faraday_cage.Vocabulary;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceRequiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionGraphGenerator {
    private Model configGraph;
    private ExecutionGraph executionGraph;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionGraphGenerator.class);

    public ExecutionGraphGenerator(Model configGraph) {
        this.configGraph = configGraph;
    }

    public ExecutionGraph generate() {
        this.executionGraph = new ExecutionGraph();
        this.configGraph.listStatements(null, Vocabulary.hasOutput(), (RDFNode)null).forEachRemaining(stmt -> {
            Resource s = stmt.getSubject();
            Resource o = stmt.getObject().asResource();
            List targets = o.canAs(RDFList.class) ? ((RDFList)o.as(RDFList.class)).iterator().filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).toList() : List.of(o);
            this.generateEdgesForResource(s, targets);
        });
        return this.executionGraph;
    }

    private void generateEdgesForResource(Resource node, List<Resource> targets) {
        AtomicInteger i = new AtomicInteger(0);
        HashMap lastToPortMap = new HashMap();
        targets.forEach(r -> {
            if (r.isAnon() && r.hasProperty(Vocabulary.toNode()) && r.hasProperty(Vocabulary.toPort())) {
                try {
                    int toPort = r.getProperty(Vocabulary.toPort()).getInt();
                    Resource toNode = r.getProperty(Vocabulary.toNode()).getResource();
                    this.executionGraph.addEdge(node, i.getAndIncrement(), toNode, toPort);
                }
                catch (NumberFormatException | LiteralRequiredException e) {
                    throw new RuntimeException("Error in definition of " + node + "! Invalid value \"" + r.getProperty(Vocabulary.toPort()).getObject() + "\" for " + Vocabulary.toPort() + ", allowed range is integer literals", e);
                }
                catch (ResourceRequiredException e) {
                    throw new RuntimeException("Error in definition of " + node + "! Invalid value \"" + r.getProperty(Vocabulary.toNode()).getObject() + "\" for " + Vocabulary.toNode() + ", allowed range is resources", e);
                }
            } else if (r.hasProperty(Vocabulary.hasInput())) {
                Resource inputs = r.getPropertyResourceValue(Vocabulary.hasInput());
                int toPort = 0;
                if (inputs.canAs(RDFList.class)) {
                    ImmutablePair con = new ImmutablePair((Object)node, r);
                    Integer lastToPort = lastToPortMap.getOrDefault(con, 0);
                    toPort = ((RDFList)inputs.as(RDFList.class)).indexOf((RDFNode)node, lastToPort.intValue());
                    lastToPortMap.put(con, toPort + 1);
                    if (toPort == -1) {
                        throw new RuntimeException("Could not find " + node + " in input declaration " + r);
                    }
                }
                this.executionGraph.addEdge(node, i.getAndIncrement(), (Resource)r, toPort);
            } else {
                this.executionGraph.addEdge(node, i.getAndIncrement(), (Resource)r, 0);
            }
        });
    }
}

