/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aksw.faraday_cage.Analytics;
import org.aksw.faraday_cage.CompletableFutureFactory;
import org.aksw.faraday_cage.Execution;
import org.aksw.faraday_cage.ExecutionFactory;
import org.aksw.faraday_cage.Parametrized;
import org.aksw.faraday_cage.Plugin;
import org.aksw.faraday_cage.nodes.Node;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.apache.jena.rdf.model.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionGraph {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionGraph.class);
    private Map<Resource, List<Edge>> edges = new HashMap<Resource, List<Edge>>();
    private Supplier<Analytics> fn = null;

    public ExecutionGraph addEdge(Resource from, int fromPort, Resource to, int toPort) {
        if (!this.edges.containsKey(from)) {
            this.edges.put(from, new ArrayList());
        }
        this.edges.get(from).add(new Edge(fromPort, toPort, to));
        return this;
    }

    public Analytics execute() {
        if (this.fn == null) {
            throw new RuntimeException("Need to compile ExecutionGraph before executing it!");
        }
        return this.fn.get();
    }

    public <T> Supplier<Analytics> compile(ExecutionFactory<T> executionFactory) {
        return this.compile(executionFactory, CompletableFutureFactory.DEFAULT);
    }

    public <T> Supplier<Analytics> compile(ExecutionFactory<T> executionFactory, CompletableFutureFactory futureFactory) {
        this.validateEdges();
        this.fn = new ExecutionGraphCompiler<T>(executionFactory, futureFactory).compile();
        return this.fn;
    }

    private void validateEdges() {
        BiConsumer<HashMap, String> checkPortNumbers = (ports, dir) -> ports.forEach((k, v) -> {
            int j = -1;
            for (Integer i : v) {
                if (i == ++j) continue;
                throw new RuntimeException("Error in " + k + ": missing " + dir + "port #" + j + "! There were " + v.size() + " ports declared.");
            }
        });
        HashMap outPorts = new HashMap();
        this.edges.forEach((key, value) -> value.forEach(c -> {
            SortedSet<Integer> set = outPorts.containsKey(key) ? (SortedSet)outPorts.get(key) : new TreeSet();
            set.add(c.getFromPort());
            outPorts.put(key, set);
        }));
        checkPortNumbers.accept(outPorts, "out");
        HashMap inPorts = new HashMap();
        this.edges.values().stream().flatMap(Collection::stream).forEach(c -> {
            TreeSet<Integer> set = inPorts.containsKey(c.getToNode()) ? (SortedSet)inPorts.get(c.getToNode()) : new TreeSet<Integer>();
            set.add(c.getToPort());
            inPorts.put(c.getToNode(), set);
        });
        checkPortNumbers.accept(inPorts, "in");
    }

    private class ExecutionGraphCompiler<T> {
        private final Map<Resource, int[]> degrees = this.getDegrees();
        private final HashMap<Resource, Execution<T>> visitedHubs = new HashMap();
        private final List<Pipeline> startPipelines = new ArrayList<Pipeline>();
        private final List<Hub> startHubs = new ArrayList<Hub>();
        private final Map<Resource, Hub> hubs = new HashMap<Resource, Hub>();
        private final CompletableFutureFactory completableFutureFactory;
        private final ExecutionFactory<T> factory;
        private Pipeline currentPipe;
        private CompletableFuture<T> joiner;
        private Analytics analytics;

        ExecutionGraphCompiler(ExecutionFactory<T> factory, CompletableFutureFactory completableFutureFactory) {
            this.factory = factory;
            this.completableFutureFactory = completableFutureFactory;
            this.joiner = completableFutureFactory.getCompletedInstance(null);
            this.currentPipe = new Pipeline();
        }

        Map<Resource, int[]> getDegrees() {
            HashMap<Resource, int[]> degrees = new HashMap<Resource, int[]>();
            ExecutionGraph.this.edges.forEach((key, value) -> degrees.put((Resource)key, new int[]{0, value.size()}));
            new ArrayList(ExecutionGraph.this.edges.entrySet()).stream().flatMap(e -> ((List)e.getValue()).stream()).map(c -> ((Edge)c).toNode).forEach(p -> {
                if (!degrees.containsKey(p)) {
                    degrees.put((Resource)p, new int[]{1, 0});
                } else {
                    ((int[])degrees.get((Object)p))[0] = ((int[])degrees.get(p))[0] + 1;
                }
            });
            return degrees;
        }

        void dfs(Edge edge, Resource parent, Deque<Resource> recStack) {
            boolean recur;
            Resource node = edge.getToNode();
            recStack.push(node);
            this.getEdges(node).forEach(next -> {
                if (recStack.contains(((Edge)next).toNode)) {
                    throw new RuntimeException("Cyclic Graph detected! Cycle in [" + StreamSupport.stream(((Iterable)recStack::descendingIterator).spliterator(), false).map(Resource::getLocalName).reduce(":", (a, b) -> a + b + ", :") + ((Edge)next).toNode.getLocalName() + "]");
                }
            });
            boolean bl = recur = !this.isHub(node);
            if (this.isHub(node) && !this.visitedHubs.containsKey(node)) {
                this.visitedHubs.put(node, this.createAndInitExecution(node));
                recur = true;
            }
            if (parent == null) {
                if (this.isHub(node)) {
                    this.addStartHub(this.visitedHubs.get(node));
                } else {
                    this.addStart(this.createAndInitExecution(node));
                }
            } else {
                int fromPort = edge.getFromPort();
                int toPort = edge.getToPort();
                boolean parentIsHub = this.isHub(parent);
                boolean nodeIsHub = this.isHub(node);
                if (parentIsHub && nodeIsHub) {
                    Execution<T> uParent = this.visitedHubs.get(parent);
                    Execution<T> uNode = this.visitedHubs.get(node);
                    this.chainFromHubToHub(uParent, fromPort, uNode, toPort);
                } else if (parentIsHub) {
                    Execution<T> uParent = this.visitedHubs.get(parent);
                    Execution<T> uNode = this.createAndInitExecution(node);
                    this.chainFromHub(uParent, fromPort, uNode);
                } else if (nodeIsHub) {
                    Execution<T> uNode = this.visitedHubs.get(node);
                    this.chainIntoHub(uNode, toPort);
                } else {
                    Execution<T> uNode = this.createAndInitExecution(node);
                    this.chain(uNode);
                }
            }
            if (recur) {
                this.getEdges(node).forEach(r -> this.dfs((Edge)r, node, recStack));
            }
            recStack.pop();
        }

        private Set<Resource> getStartNodes() {
            return this.degrees.entrySet().stream().filter(e -> ((int[])e.getValue())[0] == 0).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        private List<Edge> getEdges(Resource execution) {
            return ExecutionGraph.this.edges.getOrDefault(execution, Collections.emptyList());
        }

        private boolean isHub(Resource execution) {
            int[] d = this.degrees.get(execution);
            return d[0] > 1 || d[1] > 1;
        }

        Execution<T> createAndInitExecution(Resource executionId) {
            Execution<T> execution = this.factory.create(executionId);
            if (execution instanceof Node) {
                int[] d = this.degrees.get(executionId);
                ((Node)execution).init(executionId, d[0], d[1]);
            } else if (execution instanceof Plugin) {
                ((Plugin)execution).init(executionId);
            }
            if (execution instanceof Parametrized) {
                ParameterMap parameterMap = ((Parametrized)((Object)execution)).createParameterMap();
                parameterMap.init(executionId);
                ((Parametrized)((Object)execution)).init(parameterMap);
            }
            return execution;
        }

        @NotNull
        ExecutionGraphCompiler addStart(@NotNull Execution<T> execution) {
            this.currentPipe = new Pipeline();
            this.currentPipe.chain(execution);
            this.startPipelines.add(this.currentPipe);
            return this;
        }

        @NotNull
        ExecutionGraphCompiler addStartHub(@NotNull Execution<T> hubExecution) {
            Hub hub = new Hub(hubExecution);
            this.hubs.put(hubExecution.getId(), hub);
            this.startHubs.add(hub);
            return this;
        }

        @NotNull
        ExecutionGraphCompiler chain(@NotNull Execution<T> execution) {
            this.currentPipe.chain(execution);
            return this;
        }

        ExecutionGraphCompiler chainIntoHub(@NotNull Execution<T> to, int toPort) {
            if (!this.hubs.containsKey(to.getId())) {
                this.hubs.put(to.getId(), new Hub(to));
            }
            this.hubs.get(to.getId()).addIn(this.currentPipe, toPort);
            this.currentPipe = new Pipeline();
            return this;
        }

        ExecutionGraphCompiler chainFromHub(@NotNull Execution<T> from, int fromPort, @NotNull Execution<T> execution) {
            if (!this.hubs.containsKey(from.getId())) {
                throw new IllegalStateException("Hub needs to be declared before outgoing edges can be made");
            }
            this.currentPipe = new Pipeline();
            this.currentPipe.chain(execution);
            this.hubs.get(from.getId()).addOut(this.currentPipe, fromPort);
            return this;
        }

        @NotNull
        ExecutionGraphCompiler chainFromHubToHub(@NotNull Execution<T> from, int fromPort, @NotNull Execution<T> to, int toPort) {
            if (!this.hubs.containsKey(from.getId())) {
                throw new IllegalStateException("Hub needs to be declared before outgoing edges can be made");
            }
            if (!this.hubs.containsKey(to.getId())) {
                this.hubs.put(to.getId(), new Hub(to));
            }
            this.currentPipe = new Pipeline();
            this.hubs.get(to.getId()).addIn(this.currentPipe, toPort);
            this.hubs.get(from.getId()).addOut(this.currentPipe, fromPort);
            return this;
        }

        Supplier<Analytics> compile() {
            this.analytics = new Analytics();
            CompletableFuture trigger = this.completableFutureFactory.getInstance();
            Set<Resource> startNodes = this.getStartNodes();
            startNodes.forEach(node -> this.dfs(new Edge(0, 0, (Resource)node), null, new ArrayDeque<Resource>()));
            Consumer<CompletableFuture> addToJoiner = future -> {
                this.joiner = this.joiner.thenCombine((CompletionStage)future, (a, b) -> b);
            };
            this.startPipelines.stream().map(trigger::thenComposeAsync).forEach(addToJoiner);
            this.startHubs.stream().map(hub -> trigger.thenComposeAsync($ -> hub.execute())).forEach(addToJoiner);
            return () -> {
                trigger.complete(null);
                this.joiner.join();
                if (this.joiner.isCompletedExceptionally()) {
                    try {
                        this.joiner.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e.getCause());
                    }
                }
                return this.analytics;
            };
        }

        private class Hub {
            private List<T> inDates = new ArrayList();
            private List<T> outDates = new ArrayList();
            private CompletableFuture<Void> trigger = ExecutionGraphCompiler.access$100(ExecutionGraphCompiler.this).getInstance();
            private CompletableFuture<T> completion = ExecutionGraphCompiler.access$100(ExecutionGraphCompiler.this).getCompletedInstance(null);
            private int outCount = 0;
            private int inCount = 0;
            private boolean firstOut = true;
            private Execution<T> hubExecution;

            private Hub(Execution<T> hubExecution) {
                this.hubExecution = hubExecution;
            }

            void addIn(Pipeline in, int inIndex) {
                ++this.inCount;
                this.inDates.add(null);
                in.setCallback(data -> this.consume(data, inIndex));
            }

            void addOut(Pipeline out, int outIndex) {
                ++this.outCount;
                if (this.firstOut) {
                    this.firstOut = false;
                    CompletionStage x = ((CompletableFuture)this.trigger.thenApply($ -> this.outDates.get(outIndex))).thenCompose((Function)out);
                    this.completion = this.completion.thenCombine(x, (a, b) -> b);
                } else {
                    CompletionStage x = ((CompletableFuture)this.trigger.thenApplyAsync($ -> this.outDates.get(outIndex))).thenCompose((Function)out);
                    this.completion = this.completion.thenCombine(x, (a, b) -> b);
                }
            }

            private synchronized CompletableFuture<T> consume(T data, int i) {
                this.inDates.set(i, data);
                logger.trace("Pipe gives model to hub!");
                if (--this.inCount == 0) {
                    logger.trace("Hub executes!");
                    return this.execute();
                }
                return ExecutionGraphCompiler.this.completableFutureFactory.getCompletedInstance(null);
            }

            CompletableFuture<T> execute() {
                logger.info("{} executes", (Object)this.hubExecution.getId().toString());
                this.outDates = this.hubExecution.apply(this.inDates);
                ExecutionGraphCompiler.this.analytics.gatherFrom(this.hubExecution);
                if (this.outDates.size() != this.outCount) {
                    throw new RuntimeException("Unexpected number of generated output data from Plugin " + this.hubExecution.getId() + "(Expected: " + this.outCount + ", Actual: " + this.outDates.size() + ")");
                }
                this.trigger.complete(null);
                return this.completion;
            }
        }

        private class Pipeline
        implements Function<T, CompletableFuture<T>> {
            private CompletableFuture<T> trigger;
            private CompletableFuture<T> result;
            private Function<T, CompletableFuture<T>> callBack;
            boolean finished;

            private Pipeline() {
                this.trigger = ExecutionGraphCompiler.this.completableFutureFactory.getInstance();
                this.result = this.trigger;
                this.callBack = null;
                this.finished = false;
            }

            void setCallback(Function<T, CompletableFuture<T>> fn) {
                this.callBack = fn;
            }

            void chain(Execution<T> fn) {
                this.result = this.result.thenApply(t -> {
                    logger.info("{} executes", (Object)fn.getId().toString());
                    Object result = fn.apply(t);
                    ExecutionGraphCompiler.this.analytics.gatherFrom(fn);
                    return result;
                });
            }

            private CompletableFuture<T> callBack(T data) {
                if (this.callBack != null) {
                    return this.callBack.apply(data);
                }
                logger.trace("No callback provided: leaf encountered!");
                return ExecutionGraphCompiler.this.completableFutureFactory.getCompletedInstance(data);
            }

            @Override
            public CompletableFuture<T> apply(T data) {
                this.trigger.complete(data);
                return this.finish();
            }

            CompletableFuture<T> finish() {
                if (!this.finished) {
                    this.result = this.result.thenCompose(this::callBack);
                    this.finished = true;
                }
                return this.result;
            }
        }
    }

    private static class Edge {
        private int fromPort;
        private int toPort;
        private Resource toNode;

        private Edge(int fromPort, int toPort, Resource toNode) {
            this.fromPort = fromPort;
            this.toPort = toPort;
            this.toNode = toNode;
        }

        int getFromPort() {
            return this.fromPort;
        }

        int getToPort() {
            return this.toPort;
        }

        Resource getToNode() {
            return this.toNode;
        }
    }
}

