/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.nodes;

import org.aksw.faraday_cage.Plugin;
import org.apache.jena.rdf.model.Resource;
import org.jetbrains.annotations.NotNull;

public interface Node<T>
extends Plugin<T> {
    default public DegreeBounds getDegreeBounds() {
        return new DegreeBounds(0, 1, 0, 1);
    }

    public int getInDegree();

    public int getOutDegree();

    public void init(@NotNull Resource var1, int var2, int var3);

    public static class DegreeBounds {
        private final int minIn;
        private final int maxIn;
        private final int minOut;
        private final int maxOut;

        public DegreeBounds(int minIn, int maxIn, int minOut, int maxOut) {
            this.minIn = minIn;
            this.maxIn = maxIn;
            this.minOut = minOut;
            this.maxOut = maxOut;
        }

        public boolean notSatisfiedBy(int in, int out, boolean withImplicitCloning) {
            boolean inBounds = in >= this.minIn();
            inBounds &= in <= this.maxIn();
            inBounds &= out >= this.minOut();
            if (this.maxOut() != 1 || !withImplicitCloning) {
                inBounds &= out <= this.maxOut();
            }
            return !inBounds;
        }

        public boolean notSatisfiedBy(int in, int out) {
            return this.notSatisfiedBy(in, out, false);
        }

        public int minIn() {
            return this.minIn;
        }

        public int maxIn() {
            return this.maxIn;
        }

        public int minOut() {
            return this.minOut;
        }

        public int maxOut() {
            return this.maxOut;
        }
    }
}

