/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.nodes;

import java.util.ArrayList;
import java.util.List;
import org.aksw.faraday_cage.AnalyticsFrame;
import org.aksw.faraday_cage.nodes.DefaultAnalyticsFrame;
import org.aksw.faraday_cage.nodes.Node;
import org.apache.jena.rdf.model.Resource;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNode<T>
implements Node<T> {
    private int inDegree = -1;
    private int outDegree = -1;
    private Resource id = null;
    private boolean useImplicitCloning = false;
    private AnalyticsFrame analyticsFrame = new DefaultAnalyticsFrame();

    @Override
    public final int getInDegree() {
        return this.inDegree;
    }

    @Override
    public final int getOutDegree() {
        return this.outDegree;
    }

    @Override
    public final void init(@NotNull Resource id, int inDegree, int outDegree) {
        this.init(id);
        if (this.getDegreeBounds().notSatisfiedBy(inDegree, outDegree, this.useImplicitCloning)) {
            throw new RuntimeException("Invalid in/out degree of node " + id);
        }
        this.inDegree = inDegree;
        this.outDegree = outDegree;
    }

    @Override
    public final void init(@NotNull Resource id) {
        this.id = id;
    }

    @Override
    @NotNull
    public final Resource getId() {
        return this.id;
    }

    @Override
    public final T apply(T data) {
        List dates = this.apply(data == null ? List.of() : List.of(data));
        if (!dates.isEmpty()) {
            return (T)dates.get(0);
        }
        if (this.outDegree == 0) {
            return null;
        }
        throw new RuntimeException("Got null reference in non-leaf node.");
    }

    @Override
    public final List<T> apply(List<T> data) {
        if (!this.isInitialized()) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " must be initialized before calling apply()!");
        }
        this.writeInputAnalytics(data);
        long runTime = System.currentTimeMillis();
        ArrayList<T> result = new ArrayList<T>(this.safeApply(data));
        this.writeAnalytics("run time", System.currentTimeMillis() - runTime + "ms");
        this.writeOutputAnalytics(data);
        if (this.useImplicitCloning && this.outDegree > result.size() && result.size() == 1 && this.getDegreeBounds().maxOut() == 1) {
            for (int i = 0; i < this.outDegree - 1; ++i) {
                result.add(this.deepCopy(result.get(0)));
            }
        }
        return result;
    }

    @Override
    public boolean isInitialized() {
        return this.getInDegree() >= 0 && this.getOutDegree() >= 0 && this.id != null;
    }

    protected abstract List<T> safeApply(List<T> var1);

    protected abstract T deepCopy(T var1);

    final void useImplicitCloning(boolean useImplicitCloning) {
        this.useImplicitCloning = useImplicitCloning;
    }

    @Override
    public final AnalyticsFrame gatherAnalytics() {
        return this.analyticsFrame;
    }

    protected final void writeAnalytics(String name, String information) {
        this.analyticsFrame.put(name, information);
    }

    protected void writeInputAnalytics(List<T> data) {
    }

    protected void writeOutputAnalytics(List<T> data) {
    }

    public static abstract class WithImplicitCloning<T>
    extends AbstractNode<T> {
        public WithImplicitCloning() {
            this.useImplicitCloning(true);
        }
    }
}

