/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aksw.faraday_cage.Execution;
import org.aksw.faraday_cage.ExecutionFactory;
import org.aksw.faraday_cage.ExecutionGraph;
import org.aksw.faraday_cage.ExecutionGraphBuilder;
import org.aksw.faraday_cage.Parametrized;
import org.aksw.faraday_cage.Plugin;
import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.nodes.Node;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.util.QueryHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceRequiredException;

public class ExecutionGraphGenerator<T> {
    private Model configGraph;
    private ExecutionGraphBuilder<T> builder;
    private ExecutionFactory<T> factory;
    private Map<Resource, List<Connection>> connections;
    private Map<Resource, int[]> degrees;
    private HashMap<Resource, Execution<T>> visitedHubs = new HashMap();

    public ExecutionGraphGenerator(Model configGraph, ExecutionGraphBuilder<T> builder, ExecutionFactory<T> factory) {
        this.configGraph = configGraph;
        this.builder = builder;
        this.factory = factory;
        this.connections = this.buildConnections((Resource)Vocabulary.hasOutput());
        this.degrees = this.getDegrees();
    }

    public final ExecutionGraph generate() {
        Set<Resource> startNodes = this.getStartNodes();
        startNodes.forEach(node -> this.dfs(new Connection(0, 0, (Resource)node), null, new ArrayDeque<Resource>()));
        return this.builder.build();
    }

    private void dfs(Connection connection, Resource parent, Deque<Resource> recStack) {
        boolean recur;
        Resource node = connection.toNode;
        recStack.push(node);
        this.getConnections(node).forEach(next -> {
            if (recStack.contains(((Connection)next).toNode)) {
                throw new RuntimeException("Cyclic Graph detected! Cycle in [" + StreamSupport.stream(((Iterable)recStack::descendingIterator).spliterator(), false).map(Resource::getLocalName).reduce(":", (a, b) -> a + b + ", :") + ((Connection)next).toNode.getLocalName() + "]");
            }
        });
        boolean bl = recur = !this.isHub(node);
        if (this.isHub(node) && !this.visitedHubs.containsKey(node)) {
            this.visitedHubs.put(node, this.createAndInitExecution(node));
            recur = true;
        }
        if (parent == null) {
            if (this.isHub(node)) {
                this.builder.addStartHub(this.visitedHubs.get(node));
            } else {
                this.builder.addStart(this.createAndInitExecution(node));
            }
        } else {
            int fromPort = connection.fromPort;
            int toPort = connection.toPort;
            boolean parentIsHub = this.isHub(parent);
            boolean nodeIsHub = this.isHub(node);
            if (parentIsHub && nodeIsHub) {
                Execution<T> uParent = this.visitedHubs.get(parent);
                Execution<T> uNode = this.visitedHubs.get(node);
                this.builder.chainFromHubToHub(uParent, fromPort, uNode, toPort);
            } else if (parentIsHub) {
                Execution<T> uParent = this.visitedHubs.get(parent);
                Execution<T> uNode = this.createAndInitExecution(node);
                this.builder.chainFromHub(uParent, fromPort, uNode);
            } else if (nodeIsHub) {
                Execution<T> uNode = this.visitedHubs.get(node);
                this.builder.chainIntoHub(uNode, toPort);
            } else {
                Execution<T> uNode = this.createAndInitExecution(node);
                this.builder.chain(uNode);
            }
        }
        if (recur) {
            this.getConnections(node).forEach(r -> this.dfs((Connection)r, node, recStack));
        }
        recStack.pop();
    }

    private Execution<T> createAndInitExecution(Resource executionId) {
        Execution<T> execution = this.factory.create(executionId);
        if (execution instanceof Node) {
            int[] d = this.degrees.get(executionId);
            ((Node)execution).init(executionId, d[0], d[1]);
        } else if (execution instanceof Plugin) {
            ((Plugin)execution).init(executionId);
        }
        if (execution instanceof Parametrized) {
            ParameterMap parameterMap = ((Parametrized)((Object)execution)).createParameterMap();
            parameterMap.init(executionId);
            ((Parametrized)((Object)execution)).init(parameterMap);
        }
        return execution;
    }

    private boolean isHub(Resource execution) {
        int[] d = this.degrees.get(execution);
        return d[0] > 1 || d[1] > 1;
    }

    private List<Connection> getConnections(Resource execution) {
        return this.connections.getOrDefault(execution, Collections.emptyList());
    }

    private Set<Resource> getStartNodes() {
        return this.degrees.entrySet().stream().filter(e -> ((int[])e.getValue())[0] == 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Map<Resource, int[]> getDegrees() {
        HashMap<Resource, int[]> degrees = new HashMap<Resource, int[]>();
        this.connections.forEach((key, value) -> degrees.put((Resource)key, new int[]{0, value.size()}));
        new ArrayList<Map.Entry<Resource, List<Connection>>>(this.connections.entrySet()).stream().flatMap(e -> ((List)e.getValue()).stream()).map(c -> ((Connection)c).toNode).forEach(p -> {
            if (!degrees.containsKey(p)) {
                degrees.put((Resource)p, new int[]{1, 0});
            } else {
                ((int[])degrees.get((Object)p))[0] = ((int[])degrees.get(p))[0] + 1;
            }
        });
        return degrees;
    }

    private Map<Resource, List<Connection>> buildConnections(Resource searchProperty) {
        HashMap<Resource, List<Connection>> connectionsMap = new HashMap<Resource, List<Connection>>();
        Query q = new SelectBuilder().setDistinct(true).addVar((Object)"?op").addVar((Object)"?list").addWhere((Object)"?op", (Object)searchProperty, (Object)"?list").build();
        QueryHelper.forEachResultOf(q, this.configGraph, qs -> {
            Resource op = qs.getResource("?op");
            List base = qs.getResource("?list").canAs(RDFList.class) ? ((RDFList)qs.getResource("?list").as(RDFList.class)).iterator().filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).toList() : List.of(qs.getResource("?list"));
            AtomicInteger i = new AtomicInteger(0);
            HashMap lastToPortMap = new HashMap();
            List connections = base.stream().map(r -> {
                if (r.isAnon() && r.hasProperty(Vocabulary.toNode()) && r.hasProperty(Vocabulary.toPort())) {
                    try {
                        int toPort = r.getProperty(Vocabulary.toPort()).getInt();
                        Resource toNode = r.getProperty(Vocabulary.toNode()).getResource();
                        return new Connection(i.getAndIncrement(), toPort, toNode);
                    }
                    catch (NumberFormatException | LiteralRequiredException e) {
                        throw new RuntimeException("Error in definition of " + op + "! Invalid value \"" + r.getProperty(Vocabulary.toPort()).getObject() + "\" for " + Vocabulary.toPort() + ", allowed range is integer literals", e);
                    }
                    catch (ResourceRequiredException e) {
                        throw new RuntimeException("Error in definition of " + op + "! Invalid value \"" + r.getProperty(Vocabulary.toNode()).getObject() + "\" for " + Vocabulary.toNode() + ", allowed range is resources", e);
                    }
                }
                if (r.hasProperty(Vocabulary.hasInput())) {
                    Resource inputs = r.getPropertyResourceValue(Vocabulary.hasInput());
                    int toPort = 0;
                    if (inputs.canAs(RDFList.class)) {
                        ImmutablePair con = new ImmutablePair((Object)op, r);
                        Integer lastToPort = lastToPortMap.getOrDefault(con, 0);
                        toPort = ((RDFList)inputs.as(RDFList.class)).indexOf((RDFNode)op, lastToPort.intValue());
                        lastToPortMap.put(con, toPort + 1);
                        if (toPort == -1) {
                            throw new RuntimeException("Could not find " + op + " in input declaration " + r);
                        }
                    }
                    return new Connection(i.getAndIncrement(), toPort, (Resource)r);
                }
                return new Connection(i.getAndIncrement(), 0, (Resource)r);
            }).collect(Collectors.toList());
            connectionsMap.put(op, connections);
        });
        this.validateConnections(connectionsMap);
        return connectionsMap;
    }

    private void validateConnections(Map<Resource, List<Connection>> connectionsMap) {
        HashMap<Resource, SortedSet> inPorts = new HashMap<Resource, SortedSet>();
        connectionsMap.values().stream().flatMap(Collection::stream).forEach(c -> {
            TreeSet<Integer> set = inPorts.containsKey(((Connection)c).toNode) ? (SortedSet)inPorts.get(((Connection)c).toNode) : new TreeSet<Integer>();
            set.add(((Connection)c).toPort);
            inPorts.put(((Connection)c).toNode, set);
        });
        inPorts.forEach((k, v) -> {
            int j = -1;
            for (Integer i : v) {
                if (i == ++j) continue;
                throw new RuntimeException("Error in " + k + ": missing port #" + j + "! There were " + v.size() + " ports declared.");
            }
        });
    }

    private static class Connection {
        private int fromPort;
        private int toPort;
        private Resource toNode;

        private Connection(int fromPort, int toPort, Resource toNode) {
            this.fromPort = fromPort;
            this.toPort = toPort;
            this.toNode = toNode;
        }
    }
}

