/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.faraday_cage.Analytics;
import org.aksw.faraday_cage.CompletableFutureFactory;
import org.aksw.faraday_cage.Execution;
import org.aksw.faraday_cage.ExecutionGraph;
import org.aksw.faraday_cage.ExecutionGraphBuilder;
import org.apache.jena.rdf.model.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionGraphBuilder<T>
implements ExecutionGraphBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutionGraphBuilder.class);
    private List<Pipeline> startPipelines = new ArrayList<Pipeline>();
    private List<Hub> startHubs = new ArrayList<Hub>();
    private Map<Resource, Hub> hubs = new HashMap<Resource, Hub>();
    private Pipeline currentPipe;
    private CompletableFutureFactory completableFutureFactory;
    private CompletableFuture<T> trigger;
    private CompletableFuture<T> joiner;
    private Analytics analytics = new Analytics();

    public DefaultExecutionGraphBuilder(CompletableFutureFactory completableFutureFactory) {
        this.completableFutureFactory = completableFutureFactory;
        this.trigger = completableFutureFactory.getInstance();
        this.joiner = completableFutureFactory.getCompletedInstance(null);
        this.currentPipe = new Pipeline();
    }

    @Override
    @NotNull
    public ExecutionGraphBuilder addStart(@NotNull Execution<T> execution) {
        this.currentPipe = new Pipeline();
        this.currentPipe.chain(execution);
        this.startPipelines.add(this.currentPipe);
        return this;
    }

    @Override
    @NotNull
    public ExecutionGraphBuilder addStartHub(@NotNull Execution<T> hubExecution) {
        Hub hub = new Hub(hubExecution);
        this.hubs.put(hubExecution.getId(), hub);
        this.startHubs.add(hub);
        return this;
    }

    @Override
    @NotNull
    public ExecutionGraphBuilder chain(@NotNull Execution<T> execution) {
        this.currentPipe.chain(execution);
        return this;
    }

    @Override
    public ExecutionGraphBuilder chainIntoHub(@NotNull Execution<T> to, int toPort) {
        if (!this.hubs.containsKey(to.getId())) {
            this.hubs.put(to.getId(), new Hub(to));
        }
        this.hubs.get(to.getId()).addIn(this.currentPipe, toPort);
        this.currentPipe = new Pipeline();
        return this;
    }

    @Override
    public ExecutionGraphBuilder chainFromHub(@NotNull Execution<T> from, int fromPort, @NotNull Execution<T> execution) {
        if (!this.hubs.containsKey(from.getId())) {
            throw new IllegalStateException("Hub needs to be declared before outgoing connections can be made");
        }
        this.currentPipe = new Pipeline();
        this.currentPipe.chain(execution);
        this.hubs.get(from.getId()).addOut(this.currentPipe, fromPort);
        return this;
    }

    @Override
    @NotNull
    public ExecutionGraphBuilder chainFromHubToHub(@NotNull Execution<T> from, int fromPort, @NotNull Execution<T> to, int toPort) {
        if (!this.hubs.containsKey(from.getId())) {
            throw new IllegalStateException("Hub needs to be declared before outgoing connections can be made");
        }
        if (!this.hubs.containsKey(to.getId())) {
            this.hubs.put(to.getId(), new Hub(to));
        }
        this.currentPipe = new Pipeline();
        this.hubs.get(to.getId()).addIn(this.currentPipe, toPort);
        this.hubs.get(from.getId()).addOut(this.currentPipe, fromPort);
        return this;
    }

    @Override
    @NotNull
    public ExecutionGraph build() {
        Consumer<CompletableFuture> addToJoiner = future -> {
            this.joiner = this.joiner.thenCombine((CompletionStage)future, (a, b) -> b);
        };
        this.startPipelines.stream().map(this.trigger::thenComposeAsync).forEach(addToJoiner);
        this.startHubs.stream().map(hub -> this.trigger.thenComposeAsync($ -> hub.execute())).forEach(addToJoiner);
        return new ExecutionGraph(() -> {
            this.trigger.complete(null);
            this.joiner.join();
            if (this.joiner.isCompletedExceptionally()) {
                try {
                    this.joiner.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        }, this.analytics);
    }

    private class Hub {
        private List<T> inDates = new ArrayList();
        private List<T> outDates = new ArrayList();
        private CompletableFuture<Void> trigger = DefaultExecutionGraphBuilder.access$000(DefaultExecutionGraphBuilder.this).getInstance();
        private CompletableFuture<T> completion = DefaultExecutionGraphBuilder.access$000(DefaultExecutionGraphBuilder.this).getCompletedInstance(null);
        private int outCount = 0;
        private int inCount = 0;
        private boolean firstOut = true;
        private Execution<T> hubExecution;

        private Hub(Execution<T> hubExecution) {
            this.hubExecution = hubExecution;
        }

        void addIn(Pipeline in, int inIndex) {
            ++this.inCount;
            this.inDates.add(null);
            in.setCallback(data -> this.consume(data, inIndex));
        }

        void addOut(Pipeline out, int outIndex) {
            ++this.outCount;
            if (this.firstOut) {
                this.firstOut = false;
                CompletionStage x = ((CompletableFuture)this.trigger.thenApply($ -> this.outDates.get(outIndex))).thenCompose((Function)out);
                this.completion = this.completion.thenCombine(x, (a, b) -> b);
            } else {
                CompletionStage x = ((CompletableFuture)this.trigger.thenApplyAsync($ -> this.outDates.get(outIndex))).thenCompose((Function)out);
                this.completion = this.completion.thenCombine(x, (a, b) -> b);
            }
        }

        private synchronized CompletableFuture<T> consume(T data, int i) {
            this.inDates.set(i, data);
            logger.info("Pipe gives model to hub!");
            if (--this.inCount == 0) {
                logger.info("Hub executes!");
                return this.execute();
            }
            return DefaultExecutionGraphBuilder.this.completableFutureFactory.getCompletedInstance(null);
        }

        CompletableFuture<T> execute() {
            logger.info("{} executes", (Object)this.hubExecution.getId().toString());
            this.outDates = this.hubExecution.apply(this.inDates);
            DefaultExecutionGraphBuilder.this.analytics.gatherFrom(this.hubExecution);
            if (this.outDates.size() != this.outCount) {
                throw new RuntimeException("Unexpected number of generated output data from Plugin " + this.hubExecution.getId() + "(Expected: " + this.outCount + ", Actual: " + this.outDates.size() + ")");
            }
            this.trigger.complete(null);
            return this.completion;
        }
    }

    private class Pipeline
    implements Function<T, CompletableFuture<T>> {
        private CompletableFuture<T> trigger;
        private CompletableFuture<T> result;
        private Function<T, CompletableFuture<T>> callBack;
        boolean finished;

        private Pipeline() {
            this.trigger = DefaultExecutionGraphBuilder.this.completableFutureFactory.getInstance();
            this.result = this.trigger;
            this.callBack = null;
            this.finished = false;
        }

        void setCallback(Function<T, CompletableFuture<T>> fn) {
            this.callBack = fn;
        }

        void chain(Execution<T> fn) {
            this.result = this.result.thenApply(t -> {
                logger.info("{} executes", (Object)fn.getId().toString());
                Object result = fn.apply(t);
                DefaultExecutionGraphBuilder.this.analytics.gatherFrom(fn);
                return result;
            });
        }

        private CompletableFuture<T> callBack(T data) {
            if (this.callBack != null) {
                return this.callBack.apply(data);
            }
            logger.info("No callback provided: leaf encountered!");
            return DefaultExecutionGraphBuilder.this.completableFutureFactory.getCompletedInstance(data);
        }

        @Override
        public CompletableFuture<T> apply(T data) {
            this.trigger.complete(data);
            return this.finish();
        }

        CompletableFuture<T> finish() {
            if (!this.finished) {
                this.result = this.result.thenCompose(this::callBack);
                this.finished = true;
            }
            return this.result;
        }
    }
}

