/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage.parameter.conversions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.apache.jena.ext.com.google.common.collect.Lists;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class DictListParameterConversion
implements ParameterConversion {
    private static final short RESOURCE = 1;
    private static final short LITERAL = 2;
    private Set<Property> properties = new HashSet<Property>();
    private short force = 0;

    public DictListParameterConversion(Property ... properties) {
        this.properties.addAll(Lists.newArrayList((Object[])properties));
    }

    @Override
    public RDFNode toRDF(Object object) {
        List dictList = (List)object;
        Model model = ModelFactory.createDefaultModel();
        RDFList list = model.createList();
        dictList.forEach(dict -> {
            Resource bNode = model.createResource();
            this.properties.forEach(property -> bNode.addProperty(property, (RDFNode)dict.get(property)));
            list.add((RDFNode)bNode);
        });
        return list;
    }

    @Override
    public Object fromRDF(RDFNode node) {
        ArrayList dictList = new ArrayList();
        ((RDFList)node.as(RDFList.class)).iterator().forEachRemaining(n -> {
            Resource r = n.asResource();
            HashMap nodeMap = new HashMap();
            this.properties.forEach(p -> {
                RDFNode pValue = null;
                if (r.hasProperty(p)) {
                    pValue = r.getProperty(p).getObject();
                    switch (this.force) {
                        case 1: {
                            pValue = pValue.asResource();
                            break;
                        }
                        case 2: {
                            pValue = pValue.asLiteral();
                        }
                    }
                }
                nodeMap.put(p, pValue);
            });
            dictList.add(nodeMap);
        });
        return dictList;
    }

    public DictListParameterConversion forceResource() {
        this.force = 1;
        return this;
    }

    public DictListParameterConversion forceLiteral() {
        this.force = (short)2;
        return this;
    }
}

