/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.faraday_cage.IdentifiableExecutionFactory;
import org.aksw.faraday_cage.Plugin;
import org.aksw.faraday_cage.Vocabulary;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginManager;

public class PluginFactory<V extends Plugin<T>, T>
implements IdentifiableExecutionFactory<T> {
    private PluginManager pluginManager;
    private ExtensionFactory factory;
    private Map<Resource, Class<?>> classMap;
    private Class<V> clazz;

    public PluginFactory(Class<V> clazz, PluginManager pluginManager) {
        this.clazz = clazz;
        this.pluginManager = pluginManager;
        this.factory = pluginManager.getExtensionFactory();
        this.classMap = this.createClassMap();
    }

    private Map<Resource, Class<?>> createClassMap() {
        HashMap classMap = new HashMap();
        this.pluginManager.getExtensions(this.clazz).forEach(plugin -> classMap.put(plugin.getType(), plugin.getClass()));
        return classMap;
    }

    public final V create(Resource id) {
        Resource type = Plugin.getImplementationType(id);
        if (!this.classMap.containsKey(type)) {
            throw new RuntimeException(this.clazz.getName() + " implementation for declaration \"" + type + "\" could not be found.");
        }
        Object o = this.factory.create(this.classMap.get(type));
        if (!this.clazz.isInstance(o)) {
            throw new RuntimeException("Plugin \"" + type + "\" required as " + this.clazz.getName() + ", but has type " + o.getClass().getName());
        }
        return (V)((Plugin)this.clazz.cast(o));
    }

    @Override
    public final List<Resource> listAvailable() {
        return this.classMap.keySet().stream().peek(r -> r.addProperty(Vocabulary.implementedIn(), (RDFNode)r)).collect(Collectors.toList());
    }
}

