/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.faraday_cage;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.faraday_cage.ExecutionGraph;
import org.aksw.faraday_cage.ExecutionGraphBuilder;
import org.aksw.faraday_cage.IdentifiableExecution;
import org.aksw.faraday_cage.IdentifiableExecutionFactory;
import org.aksw.faraday_cage.Parametrized;
import org.aksw.faraday_cage.Plugin;
import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.nodes.Node;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.util.QueryHelper;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class ExecutionGraphGenerator<T> {
    private Map<Resource, List<Resource>> executionInputs = new HashMap<Resource, List<Resource>>();
    private Map<Resource, List<Resource>> executionOutputs = new HashMap<Resource, List<Resource>>();
    private HashMap<Resource, IdentifiableExecution<T>> visitedHubs = new HashMap();
    private Model configGraph;
    private ExecutionGraphBuilder<T> builder;
    private IdentifiableExecutionFactory<T> factory;
    private Deque<List<Resource>> stack;

    public ExecutionGraphGenerator(Model configGraph, ExecutionGraphBuilder<T> builder, IdentifiableExecutionFactory<T> factory) {
        this.configGraph = configGraph;
        this.builder = builder;
        this.factory = factory;
        this.stack = new ArrayDeque<List<Resource>>();
    }

    public final ExecutionGraph generate() {
        this.fillMap(this.executionInputs, (Resource)Vocabulary.hasInput());
        this.fillMap(this.executionOutputs, (Resource)Vocabulary.hasOutput());
        Set<Resource> startNodes = this.getStartNodes();
        startNodes.forEach(node -> this.stack.push(List.of(node)));
        while (!this.stack.isEmpty()) {
            IdentifiableExecution<T> uNode;
            IdentifiableExecution<T> uNode2;
            IdentifiableExecution<T> uParent;
            List<Resource> pair = this.stack.pop();
            if (pair.size() == 1) {
                Resource startNode = pair.get(0);
                this.populateStackAndMarkVisited(startNode);
                if (this.isHub(startNode)) {
                    this.builder.addStartHub(this.visitedHubs.get(startNode));
                    continue;
                }
                this.builder.addStart(this.createAndInitExecution(startNode));
                continue;
            }
            Resource parent = pair.get(0);
            Resource node2 = pair.get(1);
            this.populateStackAndMarkVisited(node2);
            int outPort = this.getNodeOutputs(parent).indexOf(node2);
            int inPort = this.getNodeInputs(node2).indexOf(parent);
            boolean parentIsHub = this.isHub(parent);
            boolean nodeIsHub = this.isHub(node2);
            if (parentIsHub && nodeIsHub) {
                uParent = this.visitedHubs.get(parent);
                uNode2 = this.visitedHubs.get(node2);
                this.builder.chainFromHubToHub(uParent, outPort, uNode2, inPort);
                continue;
            }
            if (parentIsHub) {
                uParent = this.visitedHubs.get(parent);
                uNode2 = this.createAndInitExecution(node2);
                this.builder.chainFromHub(uParent, outPort, uNode2);
                continue;
            }
            if (nodeIsHub) {
                uNode = this.visitedHubs.get(node2);
                this.builder.chainIntoHub(uNode, inPort);
                continue;
            }
            uNode = this.createAndInitExecution(node2);
            this.builder.chain(uNode);
        }
        return this.builder.build();
    }

    private void populateStackAndMarkVisited(Resource node) {
        if (!this.isHub(node) || !this.visitedHubs.containsKey(node)) {
            this.getNodeOutputs(node).forEach(r -> this.stack.push(List.of(node, r)));
            if (this.isHub(node)) {
                this.visitedHubs.put(node, this.createAndInitExecution(node));
            }
        }
    }

    protected IdentifiableExecution<T> createAndInitExecution(Resource executionId) {
        IdentifiableExecution<T> execution = this.factory.create(executionId);
        if (execution instanceof Node) {
            ((Node)execution).init(executionId, this.getNodeInputs(executionId).size(), this.getNodeOutputs(executionId).size());
        } else if (execution instanceof Plugin) {
            ((Plugin)execution).init(executionId);
        }
        if (execution instanceof Parametrized) {
            ParameterMap parameterMap = ((Parametrized)((Object)execution)).createParameterMap();
            parameterMap.init(executionId);
            ((Parametrized)((Object)execution)).init(parameterMap);
        }
        return execution;
    }

    protected final boolean isHub(Resource execution) {
        return this.getNodeInputs(execution).size() > 1 || this.getNodeOutputs(execution).size() > 1;
    }

    private void fillMap(Map<Resource, List<Resource>> map, Resource searchProperty) {
        Query q = new SelectBuilder().setDistinct(true).addVar((Object)"?op").addVar((Object)"?list").addWhere((Object)"?op", (Object)searchProperty, (Object)"?list").build();
        QueryHelper.forEachResultOf(q, this.configGraph, qs -> map.put(qs.getResource("?op"), ((RDFList)qs.getResource("?list").as(RDFList.class)).mapWith(RDFNode::asResource).toList()));
    }

    protected final List<Resource> getNodeInputs(Resource execution) {
        return this.executionInputs.getOrDefault(execution, Collections.emptyList());
    }

    protected final List<Resource> getNodeOutputs(Resource execution) {
        return this.executionOutputs.getOrDefault(execution, Collections.emptyList());
    }

    protected final Set<Resource> getStartNodes() {
        return Sets.difference(this.executionOutputs.keySet(), this.executionInputs.keySet());
    }
}

