/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aksw.deer.DeerExecutionNode;
import org.aksw.deer.ParameterizedDeerExecutionNode;
import org.aksw.deer.enrichments.EnrichmentOperator;
import org.aksw.deer.learning.EvaluationResult;
import org.aksw.deer.learning.FitnessFunction;
import org.aksw.deer.learning.genetic.RandomGenotype;
import org.aksw.deer.learning.genetic.RandomOperatorFactory;
import org.aksw.deer.learning.genetic.SelfConfigurationWrapper;
import org.aksw.deer.learning.genetic.TrainingData;
import org.aksw.faraday_cage.engine.CompiledExecutionGraph;
import org.aksw.faraday_cage.engine.ExecutionGraph;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ThreadlocalInheritingCompletableFuture;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class Genotype
extends ExecutionGraph<Model> {
    public static int SIZE = 30;
    protected TrainingData trainingData;
    int bestResultRow = -1;
    private double bestFitness = -1.0;
    EvaluationResult[] results = null;
    boolean evaluated = false;
    private Multimap<Integer, Integer> transitiveHull = null;
    private Set<Integer> outputs = null;

    protected Genotype() {
        super(SIZE);
    }

    protected Genotype(int size) {
        super(size);
    }

    protected Genotype(TrainingData trainingData) {
        super(SIZE);
        this.trainingData = trainingData;
        int currentRow = 0;
        for (ParameterizedDeerExecutionNode reader : trainingData.getTrainingReaders()) {
            this.addRow(currentRow++, reader, new int[]{0, 1});
        }
    }

    public Genotype(Genotype other) {
        super(other.getSize());
        this.trainingData = other.trainingData;
        for (int i = 0; i < this.getSize(); ++i) {
            this.entries[i] = Arrays.copyOf(other.entries[i], other.entries[i].length);
            if (i >= this.getNumberOfInputs()) {
                this.ops.set(i, RandomOperatorFactory.reproduce((EnrichmentOperator)other.ops.get(i)));
                continue;
            }
            this.ops.set(i, (ExecutionNode)other.ops.get(i));
        }
    }

    Genotype getEvaluatedCopy(boolean evaluated) {
        Genotype copy = new Genotype(this);
        copy.results = Arrays.copyOf(this.results, this.results.length);
        copy.bestFitness = this.bestFitness;
        copy.bestResultRow = this.bestResultRow;
        copy.evaluated = evaluated;
        return copy;
    }

    Genotype getEvaluatedCopy() {
        return this.getEvaluatedCopy(true);
    }

    ExecutionNode<Model> getRawNode(int i) {
        return (ExecutionNode)this.ops.get(i);
    }

    public ExecutionNode<Model> getNode(int i) {
        return this.getWrappedNode(i);
    }

    private ExecutionNode<Model> getWrappedNode(int i) {
        if (i < this.getNumberOfInputs()) {
            return (ExecutionNode)this.ops.get(i);
        }
        return SelfConfigurationWrapper.wrap((DeerExecutionNode)this.ops.get(i), evaluationResult -> {
            this.results[i] = evaluationResult;
        }, this.trainingData.getTrainingTarget());
    }

    private CompletableFuture<EvaluationResult> evaluate(FitnessFunction f) {
        CompiledExecutionGraph compiled = CompiledExecutionGraph.of((ExecutionGraph)this);
        CompletableFuture completionStage = compiled.getCompletionStage();
        CompletionStage result = completionStage.thenApply(x -> this.findAndSetBestEvaluationResult(f));
        compiled.run();
        return result;
    }

    private EvaluationResult findAndSetBestEvaluationResult(FitnessFunction f) {
        for (int i = this.getNumberOfInputs(); i < this.results.length; ++i) {
            double fitness = f.getFitness(this.results[i]);
            if (!(fitness > this.bestFitness)) continue;
            this.bestFitness = fitness;
            this.bestResultRow = i;
        }
        this.evaluated = true;
        return this.results[this.bestResultRow];
    }

    public CompletableFuture<EvaluationResult> getBestEvaluationResult() {
        return this.getBestEvaluationResult(this.trainingData.getFitnessFunction());
    }

    public CompletableFuture<EvaluationResult> getBestEvaluationResult(FitnessFunction f) {
        if (!this.evaluated) {
            this.results = new EvaluationResult[this.getSize()];
            this.bestResultRow = -1;
            this.bestFitness = -1.0;
            return this.evaluate(f);
        }
        return ThreadlocalInheritingCompletableFuture.completedFuture((Object)this.results[this.bestResultRow]);
    }

    public double getBestFitness() {
        return this.bestFitness;
    }

    int getNumberOfInputs() {
        return this.trainingData.getTrainingSources().size();
    }

    Genotype compactBestResult(boolean shrink, int rightShiftSize) {
        TreeSet<Integer> relevantRows = new TreeSet<Integer>(this.getRelevantRows(this.bestResultRow));
        relevantRows.add(this.bestResultRow);
        for (int i = 0; i < this.getNumberOfInputs(); ++i) {
            relevantRows.add(i);
        }
        HashMap<Integer, Integer> skipMap = new HashMap<Integer, Integer>();
        List<Model> trainingSources = this.trainingData.getTrainingSources();
        Iterator iterator = relevantRows.iterator();
        block1: while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i < this.getNumberOfInputs()) continue;
            for (int input : this.getInputs(i)) {
                if (skipMap.containsKey(input)) {
                    input = (Integer)skipMap.get(input);
                }
                if (!this.getResultModel(input).isIsomorphicWith(this.getResultModel(i))) continue;
                skipMap.put(i, input);
                continue block1;
            }
        }
        Genotype compacted = shrink ? new Genotype(relevantRows.size() - skipMap.size()) : new Genotype();
        if (rightShiftSize < 0) {
            rightShiftSize = 0;
        }
        compacted.trainingData = this.trainingData;
        compacted.results = new EvaluationResult[compacted.getSize()];
        int k = 0;
        List<ParameterizedDeerExecutionNode> readers = this.trainingData.getEvaluationReaders();
        int[] rowMapping = new int[this.getSize()];
        Iterator iterator2 = relevantRows.iterator();
        while (iterator2.hasNext()) {
            int i = (Integer)iterator2.next();
            if (k < readers.size()) {
                rowMapping[i] = k;
                compacted.addRow(k, readers.get(k++), this.getRow(i));
                continue;
            }
            if (skipMap.containsKey(i)) continue;
            rowMapping[i] = k + rightShiftSize;
            int[] row = Arrays.copyOf(this.getRow(i), this.getRow(i).length);
            int arity = row[0];
            for (int j = 0; j < arity; ++j) {
                int inputIndex = row[2 + 2 * j];
                if (skipMap.containsKey(inputIndex)) {
                    inputIndex = (Integer)skipMap.get(inputIndex);
                }
                row[2 + 2 * j] = inputIndex = rowMapping[inputIndex];
            }
            compacted.results[rightShiftSize + k] = this.results[i];
            compacted.addRow(rightShiftSize + k++, RandomOperatorFactory.reproduce((EnrichmentOperator)this.getRawNode(i)), row);
        }
        compacted.bestResultRow = rightShiftSize + relevantRows.size() - 1 - skipMap.size();
        compacted.bestFitness = this.bestFitness;
        for (int i = 0; i < compacted.getSize(); ++i) {
            if (compacted.getRawNode(i) != null) continue;
            RandomGenotype.addRandomRow(compacted, i);
        }
        return compacted;
    }

    private Model getResultModel(int i) {
        if (i < this.trainingData.getTrainingSources().size()) {
            return this.trainingData.getTrainingSources().get(i);
        }
        return this.results[i].getResultModel();
    }

    Set<Resource> getSmell() {
        HashSet<Resource> smell = new HashSet<Resource>();
        for (int i = this.getNumberOfInputs(); i <= this.bestResultRow; ++i) {
            smell.add(this.getRawNode(i).getType());
        }
        return smell;
    }

    List<Resource> getSmell(boolean full) {
        ArrayList<Resource> smell = new ArrayList<Resource>();
        for (int i = this.getNumberOfInputs(); i <= (full ? this.getSize() : this.bestResultRow); ++i) {
            smell.add(this.getRawNode(i).getType());
        }
        return smell;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getSize(); ++i) {
            sb.append(((ExecutionNode)this.ops.get(i)).getType().getLocalName());
            sb.append(" ");
            sb.append(this.entries[i][0]);
            sb.append(" ");
            sb.append(this.entries[i][1]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<Integer> getInputs(int i) {
        int[] row = this.getRow(i);
        int n = row[0];
        ArrayList<Integer> result = new ArrayList<Integer>(n);
        for (int j = 0; j < n; ++j) {
            result.add(row[2 + 2 * j]);
        }
        return result;
    }

    public List<Model> getInputModels(int i) {
        return this.getInputs(i).stream().map(this::getResultModel).collect(Collectors.toList());
    }

    public Collection<Integer> getRelevantRows(int i) {
        if (this.transitiveHull == null) {
            this.computeTransitiveHullAndOutputs();
        }
        return this.transitiveHull.get((Object)i);
    }

    private void computeTransitiveHullAndOutputs() {
        this.transitiveHull = HashMultimap.create();
        this.outputs = IntStream.range(0, this.getSize()).boxed().collect(Collectors.toSet());
        for (int i = this.getNumberOfInputs(); i < this.getSize(); ++i) {
            List<Integer> inputs = this.getInputs(i);
            for (int j : inputs) {
                if (!this.transitiveHull.containsKey((Object)j)) continue;
                this.transitiveHull.putAll((Object)i, (Iterable)this.transitiveHull.get((Object)j));
            }
            this.transitiveHull.putAll((Object)i, inputs);
            this.outputs.removeAll(this.transitiveHull.get((Object)i));
        }
    }
}

