/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.io;

import java.util.List;
import java.util.Optional;
import org.aksw.deer.io.AbstractModelReader;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class SparqlModelReader
extends AbstractModelReader {
    private static final Logger logger = LoggerFactory.getLogger(SparqlModelReader.class);
    public static final Property FROM_ENDPOINT = DEER.property("fromEndpoint");
    public static final Property USE_SPARQL_CONSTRUCT = DEER.property("useSparqlConstruct");
    public static final Property USE_SPARQL_DESCRIBE_OF = DEER.property("useSparqlDescribeOf");

    @Override
    public String getDescription() {
        return "Read output from SPARQL endpoint.";
    }

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(FROM_ENDPOINT).declareProperty(USE_SPARQL_CONSTRUCT).declareProperty(USE_SPARQL_DESCRIBE_OF).declareValidationShape(SparqlModelReader.getValidationModelFor(SparqlModelReader.class)).build();
    }

    protected List<Model> safeApply(List<Model> data) {
        return (List)ExecutionNode.toMultiExecution(m -> this.readModelFromEndPoint()).apply(data);
    }

    private Model readModelFromEndPoint() {
        Model result;
        ValidatableParameterMap parameters = this.getParameterMap();
        String fromEndpoint = parameters.get(FROM_ENDPOINT).asResource().getURI();
        Optional<String> sparqlQuery = parameters.getOptional(USE_SPARQL_CONSTRUCT).map(RDFNode::asLiteral).map(Literal::getString);
        Optional<String> describeTarget = parameters.getOptional(USE_SPARQL_DESCRIBE_OF).map(RDFNode::asResource).map(Resource::getURI);
        long startTime = System.currentTimeMillis();
        logger.info("Reading dataset from " + fromEndpoint);
        if (sparqlQuery.isPresent()) {
            QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(fromEndpoint);
            qef = new QueryExecutionFactoryDelay((QueryExecutionFactory)qef, 500L);
            qef = new QueryExecutionFactoryPaginated((QueryExecutionFactory)qef, 5000L);
            String sparqlQueryString = sparqlQuery.get();
            QueryExecution queryExecution = qef.createQueryExecution(sparqlQueryString);
            result = queryExecution.execConstruct();
            queryExecution.close();
        } else if (describeTarget.isPresent()) {
            String sparqlQueryString = "DESCRIBE <" + describeTarget.get() + ">";
            QueryEngineHTTP qExec = new QueryEngineHTTP(fromEndpoint, sparqlQueryString);
            qExec.setModelContentType("application/ld+json");
            result = qExec.execDescribe();
            qExec.close();
        } else {
            throw new RuntimeException("Neither " + USE_SPARQL_DESCRIBE_OF.toString() + " nor " + USE_SPARQL_CONSTRUCT.toString() + " defined to read dataset from " + fromEndpoint + ", exit with error.");
        }
        logger.info("Dataset reading is done in {}ms, {} triples found.", (Object)(System.currentTimeMillis() - startTime), (Object)result.size());
        return result;
    }
}

