/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.aksw.deer.io.AbstractModelWriter;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class FileModelWriter
extends AbstractModelWriter {
    private static final Logger logger = LoggerFactory.getLogger(FileModelWriter.class);
    public static final Property OUTPUT_FILE = DEER.property("outputFile");
    public static final Property OUTPUT_FORMAT = DEER.property("outputFormat");

    @Override
    public String getDescription() {
        return "Serialize input to a file.";
    }

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(OUTPUT_FILE).declareProperty(OUTPUT_FORMAT).declareValidationShape(FileModelWriter.getValidationModelFor(FileModelWriter.class)).build();
    }

    protected List<Model> safeApply(List<Model> data) {
        return (List)ExecutionNode.toMultiExecution(this::write).apply(data);
    }

    private Model write(Model model) {
        String outputFile = FileModelWriter.injectWorkingDirectory(this.getParameterMap().get(OUTPUT_FILE).asLiteral().getString());
        String outputFormat = this.getParameterMap().getOptional(OUTPUT_FORMAT).map(RDFNode::asLiteral).map(Literal::getString).orElse("TTL");
        try {
            logger.info("Saving dataset to " + outputFile + "...");
            long starTime = System.currentTimeMillis();
            File writingDir = new File(outputFile).getParentFile();
            if (writingDir != null && !writingDir.exists()) {
                writingDir.mkdirs();
            }
            model.write((Writer)new FileWriter(outputFile), outputFormat);
            logger.info("Saving dataset done in " + (System.currentTimeMillis() - starTime) + "ms.");
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered problem while trying to write dataset to " + outputFile, e);
        }
        return model;
    }
}

