/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Optional;
import org.aksw.deer.io.AbstractModelReader;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class FileModelReader
extends AbstractModelReader {
    private static final Logger logger = LoggerFactory.getLogger(FileModelReader.class);
    public static final Property FROM_PATH = DEER.property("fromPath");
    public static final Property FROM_URI = DEER.property("fromUri");

    @Override
    public String getDescription() {
        return "Read input from a file.";
    }

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(FROM_PATH).declareProperty(FROM_URI).declareValidationShape(FileModelReader.getValidationModelFor(FileModelReader.class)).build();
    }

    protected List<Model> safeApply(List<Model> data) {
        Optional<String> path = this.getParameterMap().getOptional(FROM_PATH).map(RDFNode::asLiteral).map(Literal::getString);
        Optional<String> uri = this.getParameterMap().getOptional(FROM_URI).map(RDFNode::asLiteral).map(Literal::getString);
        String locator = "";
        if (path.isPresent()) {
            try {
                locator = FileModelReader.injectWorkingDirectory(path.get());
            }
            catch (InvalidPathException e) {
                logger.info("Invalid path {} specified in {} {}!", new Object[]{path, this.getType(), this.getId()});
                logger.info("Gracefully trying to use it as URI to load the model.");
                locator = path.get();
            }
        } else if (uri.isPresent()) {
            try {
                locator = new URI(uri.get()).toString();
            }
            catch (URISyntaxException e) {
                logger.info("Invalid URI {} specified in {} {}!", new Object[]{path, this.getType(), this.getId()});
                logger.info("Gracefully trying to use it as path to load the model.");
                locator = uri.get();
            }
        }
        long startTime = System.currentTimeMillis();
        Model result = ModelFactory.createDefaultModel().read(locator);
        logger.info("Loading {} is done in {}ms.", (Object)locator, (Object)(System.currentTimeMillis() - startTime));
        return List.of(result);
    }
}

