/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.util.List;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.enrichments.AuthorityConformationEnrichmentOperator;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.update.UpdateAction;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class SparqlUpdateEnrichmentOperator
extends AbstractParameterizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityConformationEnrichmentOperator.class);
    public static final Property UPDATE = DEER.property("sparqlUpdateQuery");

    @Override
    public String getDescription() {
        return "Apply a SPARQL UPDATE query to the input graph";
    }

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(UPDATE).declareValidationShape(SparqlUpdateEnrichmentOperator.getValidationModelFor(SparqlUpdateEnrichmentOperator.class)).build();
    }

    protected List<Model> safeApply(List<Model> models) {
        Model model = ModelFactory.createDefaultModel().add(models.get(0));
        String updateStatement = this.getParameterMap().get(UPDATE).asLiteral().getString();
        UpdateAction.parseExecute((String)updateStatement, (Model)model);
        return Lists.newArrayList((Object[])new Model[]{model});
    }
}

