/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.enrichments.AuthorityConformationEnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PredicateConformationEnrichmentOperator
extends AbstractParameterizedEnrichmentOperator
implements ReverseLearnable,
SelfConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityConformationEnrichmentOperator.class);
    public static final Property SOURCE_PREDICATE = DEER.property("sourcePredicate");
    public static final Property TARGET_PREDICATE = DEER.property("targetPredicate");
    public static final Property OPERATION = DEER.property("operation");

    @Override
    public String getDescription() {
        return "Rename predicates";
    }

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(OPERATION).declareValidationShape(PredicateConformationEnrichmentOperator.getValidationModelFor(PredicateConformationEnrichmentOperator.class)).build();
    }

    protected List<Model> safeApply(List<Model> models) {
        Model model = models.get(0);
        Model conformModel = ModelFactory.createDefaultModel();
        HashMap propertyMapping = new HashMap();
        this.getParameterMap().listPropertyObjects(OPERATION).map(RDFNode::asResource).forEach(op -> {
            Property source = (Property)op.getPropertyResourceValue(SOURCE_PREDICATE).as(Property.class);
            Property target = (Property)op.getPropertyResourceValue(TARGET_PREDICATE).as(Property.class);
            propertyMapping.put(source, target);
        });
        model.listStatements().forEachRemaining(stmt -> {
            Property p = stmt.getPredicate();
            if (propertyMapping.containsKey(p)) {
                p = (Property)propertyMapping.get(p);
            }
            conformModel.add(stmt.getSubject(), p, stmt.getObject());
        });
        return Lists.newArrayList((Object[])new Model[]{conformModel});
    }

    @Override
    public double predictApplicability(List<Model> inputs, Model target) {
        return this.learnParameterMap(inputs, target, null).listPropertyObjects(OPERATION).count() > 0L ? 1.0 : 0.0;
    }

    @Override
    public List<Model> reverseApply(List<Model> inputs, Model target) {
        ValidatableParameterMap reverseParameterMap = this.createParameterMap();
        this.learnParameterMap(inputs, target, null).listPropertyObjects(OPERATION).forEach(r -> reverseParameterMap.add(OPERATION, (RDFNode)reverseParameterMap.createResource().addProperty(SOURCE_PREDICATE, (RDFNode)r.asResource().getPropertyResourceValue(TARGET_PREDICATE)).addProperty(TARGET_PREDICATE, (RDFNode)r.asResource().getPropertyResourceValue(SOURCE_PREDICATE))));
        this.initParameters(reverseParameterMap.init());
        return this.safeApply(List.of(target));
    }

    @Override
    public ValidatableParameterMap learnParameterMap(List<Model> inputs, Model target, ValidatableParameterMap prototype) {
        ValidatableParameterMap result = this.createParameterMap();
        Model source = inputs.get(0);
        HashSet seen = new HashSet();
        source.listStatements().forEachRemaining(s -> {
            if (seen.contains(s.getPredicate())) {
                return;
            }
            seen.add(s.getPredicate());
            target.listStatements(s.getSubject(), null, s.getObject()).nextOptional().ifPresent(t -> {
                if (!Objects.equals(s.getPredicate(), t.getPredicate())) {
                    result.add(OPERATION, (RDFNode)result.createResource().addProperty(SOURCE_PREDICATE, (RDFNode)s.getPredicate()).addProperty(TARGET_PREDICATE, (RDFNode)t.getPredicate()));
                }
            });
        });
        return result.init();
    }

    @Override
    public ExecutionNode.DegreeBounds getLearnableDegreeBounds() {
        return this.getDegreeBounds();
    }
}

