/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.aksw.deer.DeerAnalyticsStore;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.enrichments.MergeEnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.FaradayCageContext;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.aksw.limes.core.controller.Controller;
import org.aksw.limes.core.controller.LSPipeline;
import org.aksw.limes.core.controller.MLPipeline;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.OWL;
import org.json.JSONObject;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class LinkingEnrichmentOperator
extends AbstractParameterizedEnrichmentOperator
implements SelfConfigurable,
ReverseLearnable {
    private static final Logger logger = LoggerFactory.getLogger(LinkingEnrichmentOperator.class);
    public static final Property LINKING_PREDICATE = DEER.property("linkingPredicate");
    public static final Property THRESHOLD = DEER.property("threshold");
    public static final Property SELECT_MODE = DEER.property("selectMode");
    public static final Property LINKS_PART = DEER.property("linksPart");
    public static final Property SPEC_FILE = DEER.property("specFile");
    public static final Property LINK_SPECIFICATION = DEER.property("linkSpecification");
    public static final Property USE_ML = DEER.property("useML");
    private static Supplier<ValidatableParameterMap> parameterMapSupplier = null;

    @Override
    public String getDescription() {
        return "Perform link discovery using LIMES";
    }

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(SPEC_FILE).declareProperty(LINKS_PART).declareProperty(SELECT_MODE).declareProperty(LINK_SPECIFICATION).declareProperty(LINKING_PREDICATE).declareProperty(THRESHOLD).declareValidationShape(LinkingEnrichmentOperator.getValidationModelFor(LinkingEnrichmentOperator.class)).build();
    }

    protected List<Model> safeApply(List<Model> models) {
        ValidatableParameterMap parameters = this.getParameterMap();
        Optional<String> specFile = parameters.getOptional(SPEC_FILE).map(RDFNode::asLiteral).map(Literal::getString);
        Optional<String> linkSpecification = parameters.getOptional(LINK_SPECIFICATION).map(RDFNode::asLiteral).map(Literal::getString);
        double threshold = parameters.getOptional(THRESHOLD).map(RDFNode::asLiteral).map(Literal::getDouble).orElse(0.9);
        boolean useML = parameters.getOptional(USE_ML).map(RDFNode::asLiteral).map(Literal::getBoolean).orElse(false);
        DATASET_PART linksPart = parameters.getOptional(LINKS_PART).map(n -> n.asLiteral().getString().toUpperCase()).map(DATASET_PART::valueOf).orElse(DATASET_PART.SOURCE);
        if (this.getInDegree() == 1 && specFile.isPresent()) {
            Model model = this.setPrefixes(models.get(0));
            if (model.size() == 0L) {
                return List.of(model);
            }
            Configuration cfg = new XMLConfigurationReader(specFile.get()).read();
            Property linkingPredicate = ResourceFactory.createProperty((String)cfg.getAcceptanceRelation());
            if (this.getOutDegree() == 1) {
                this.addLinksToModel(linksPart, model, this.getMappingFromConfiguration(cfg), linkingPredicate);
                return Lists.newArrayList((Object[])new Model[]{model});
            }
            Model linkModel = ModelFactory.createDefaultModel();
            this.addLinksToModel(linksPart, linkModel, this.getMappingFromConfiguration(cfg), linkingPredicate);
            return Lists.newArrayList((Object[])new Model[]{model, linkModel});
        }
        if (this.getInDegree() == 2) {
            ACache source = this.modelToCache(models.get(0));
            ACache target = this.modelToCache(models.get(1));
            if (models.get(0).size() == 0L || models.get(1).size() == 0L) {
                if (this.getOutDegree() == 1) {
                    return List.of(models.get(0).add(models.get(1)));
                }
                if (this.getOutDegree() == 2) {
                    return models;
                }
                return List.of(models.get(0), models.get(1), ModelFactory.createDefaultModel());
            }
            AMapping mapping = MappingFactory.createDefaultMapping();
            if (linkSpecification.isPresent()) {
                mapping = LSPipeline.execute((ACache)source, (ACache)target, (LinkSpecification)new LinkSpecification(linkSpecification.get(), threshold));
            } else if (useML) {
                Configuration cfg = new Configuration();
                cfg.setMlAlgorithmName("Wombat Simple");
                cfg.setMlImplementationType(MLImplementationType.UNSUPERVISED);
                cfg.setMlPseudoFMeasure(EvaluatorType.PF_MEASURE);
                cfg.setMlAlgorithmParameters(List.of());
                try {
                    mapping = MLPipeline.execute((ACache)source, (ACache)target, (Configuration)cfg, (String)cfg.getMlAlgorithmName(), (MLImplementationType)cfg.getMlImplementationType(), (List)cfg.getMlAlgorithmParameters(), (String)"", (EvaluatorType)cfg.getMlPseudoFMeasure(), (int)0);
                }
                catch (UnsupportedMLImplementationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            mapping = this.applySelectModeToMapping(mapping);
            if (this.getOutDegree() == 1) {
                this.addLinksToModel(linksPart, models.get(0), mapping);
                return new MergeEnrichmentOperator().safeApply(models);
            }
            if (this.getOutDegree() == 2) {
                this.addLinksToModel(linksPart, models.get(linksPart == DATASET_PART.SOURCE ? 0 : 1), mapping);
                return models;
            }
            Model linkModel = ModelFactory.createDefaultModel();
            this.addLinksToModel(linksPart, linkModel, mapping);
            return Lists.newArrayList((Object[])new Model[]{models.get(0), models.get(1), linkModel});
        }
        if (this.getInDegree() == 1) {
            throw new IllegalStateException("Incoming edges amount to 1 but " + SPEC_FILE + " not declared in " + this.getId() + "!");
        }
        throw new IllegalStateException("Incoming edges amount to 2 but neither " + LINK_SPECIFICATION + " nor " + USE_ML + " declared in " + this.getId() + "!");
    }

    @Override
    public ExecutionNode.DegreeBounds getDegreeBounds() {
        return new ExecutionNode.DegreeBounds(1, 2, 1, 3);
    }

    private Model setPrefixes(Model model) {
        String gn = "http://www.geonames.org/ontology#";
        String owl = "http://www.w3.org/2002/07/owl#";
        model.setNsPrefix("gn", gn);
        model.setNsPrefix("owl", owl);
        return model;
    }

    private AMapping getMappingFromConfiguration(Configuration cfg) {
        AMapping mapping = Controller.getMapping((Configuration)cfg).getAcceptanceMapping();
        return this.applySelectModeToMapping(mapping);
    }

    private AMapping applySelectModeToMapping(AMapping mapping) {
        AMapping result = mapping;
        SELECT selectMode = this.getParameterMap().getOptional(SELECT_MODE).map(n -> n.asLiteral().getString().toUpperCase()).map(SELECT::valueOf).orElse(SELECT.ALL);
        switch (selectMode) {
            case BEST: {
                HashMap reversedMap = mapping.getReversedMap();
                double best = 0.0;
                for (Double sim : reversedMap.keySet()) {
                    if (!(sim > best)) continue;
                    Map.Entry entry = ((HashMap)reversedMap.get(sim)).entrySet().iterator().next();
                    result = MappingFactory.createDefaultMapping();
                    result.add((String)entry.getKey(), (String)((TreeSet)entry.getValue()).first(), sim.doubleValue());
                }
                break;
            }
            case BEST1TO1: {
                result = mapping.getBestOneToOneMappings(mapping);
                break;
            }
            case BEST1TON: {
                result = mapping.getBestOneToNMapping();
            }
        }
        DeerAnalyticsStore.write(FaradayCageContext.getRunId(), this.getId(), new JSONObject().put("newDiscoveredLinks", result.size()));
        return result;
    }

    private void addLinksToModel(DATASET_PART linksPart, Model model, AMapping mapping) {
        Property linkingPredicate = (Property)this.getParameterMap().get(LINKING_PREDICATE).as(Property.class);
        this.addLinksToModel(linksPart, model, mapping, linkingPredicate);
    }

    private void addLinksToModel(DATASET_PART linksPart, Model model, AMapping mapping, Property linkingPredicate) {
        for (String s : mapping.getMap().keySet()) {
            Resource subject = model.createResource(s);
            for (String t : ((HashMap)mapping.getMap().get(s)).keySet()) {
                Resource object = model.createResource(t);
                if (linksPart == DATASET_PART.SOURCE) {
                    model.add(subject, linkingPredicate, (RDFNode)object);
                    continue;
                }
                model.add(object, linkingPredicate, (RDFNode)subject);
            }
        }
    }

    private ACache modelToCache(Model m) {
        MemoryCache cache = new MemoryCache();
        m.listStatements().filterDrop(stmt -> stmt.getObject().isAnon()).forEachRemaining(arg_0 -> LinkingEnrichmentOperator.lambda$modelToCache$3((ACache)cache, arg_0));
        return cache;
    }

    @Override
    public double predictApplicability(List<Model> inputs, Model target) {
        Model s = inputs.get(0);
        Model t = inputs.get(1);
        List sameAs = target.listStatements(null, OWL.sameAs, (RDFNode)null).toList();
        return (double)sameAs.size() == 0.0 ? 0.0 : 0.5 + sameAs.stream().filter(stmt -> !s.contains(stmt) && !t.contains(stmt) && (this.isPotentialLink(s, t, (Statement)stmt) || this.isPotentialLink(t, s, (Statement)stmt))).mapToDouble(stmt -> 1.0).sum() / (double)(2 * sameAs.size());
    }

    @Override
    public List<Model> reverseApply(List<Model> inputs, Model target) {
        Model sI = inputs.get(0);
        Model tI = inputs.get(1);
        Model s = ModelFactory.createDefaultModel();
        Model t = ModelFactory.createDefaultModel();
        List straightLinks = target.listStatements(null, OWL.sameAs, (RDFNode)null).filterKeep(stmt -> !sI.contains(stmt) && !tI.contains(stmt) && this.isPotentialLink(sI, tI, (Statement)stmt)).toList();
        List inverseLinks = target.listStatements(null, OWL.sameAs, (RDFNode)null).filterKeep(stmt -> !sI.contains(stmt) && !tI.contains(stmt) && this.isPotentialLink(tI, sI, (Statement)stmt)).mapWith(stmt -> target.createStatement(stmt.getResource(), stmt.getPredicate(), (RDFNode)stmt.getSubject())).toList();
        boolean invert = straightLinks.size() < inverseLinks.size();
        (invert ? inverseLinks : straightLinks).forEach(stmt -> {
            this.addSubgraphOfResourceToModel(stmt.getSubject(), s);
            this.addSubgraphOfResourceToModel(stmt.getResource(), t);
        });
        return List.of(s, t);
    }

    private boolean isPotentialLink(Model s, Model t, Statement stmt) {
        return stmt.getObject().isResource() && s.contains(stmt.getSubject(), null) && t.contains(stmt.getResource(), null);
    }

    private void addSubgraphOfResourceToModel(Resource resource, Model model) {
        ArrayDeque<Resource> stack = new ArrayDeque<Resource>();
        HashSet<Resource> visited = new HashSet<Resource>();
        stack.push(resource);
        while (!stack.isEmpty()) {
            RDFNode n = (RDFNode)stack.pop();
            if (!n.isResource() || visited.contains(n.asResource())) continue;
            Resource r = n.asResource();
            r.listProperties().filterDrop(stmt -> stmt.getPredicate().equals(OWL.sameAs)).forEachRemaining(stmt -> {
                model.add(stmt);
                stack.push((Resource)stmt.getObject());
            });
            visited.add(r);
        }
    }

    @Override
    public ValidatableParameterMap learnParameterMap(List<Model> inputs, Model target, ValidatableParameterMap prototype) {
        if (parameterMapSupplier != null) {
            return parameterMapSupplier.get();
        }
        return this.createParameterMap().add(USE_ML, (RDFNode)ResourceFactory.createTypedLiteral((Object)true)).add(LINKING_PREDICATE, (RDFNode)OWL.sameAs).init();
    }

    @Override
    public ExecutionNode.DegreeBounds getLearnableDegreeBounds() {
        return new ExecutionNode.DegreeBounds(2, 2, 1, 1);
    }

    public static void setStaticLearning(Supplier<ValidatableParameterMap> x) {
        parameterMapSupplier = x;
    }

    private static /* synthetic */ void lambda$modelToCache$3(ACache cache, Statement stmt) {
        cache.addTriple(stmt.getSubject().getURI(), stmt.getPredicate().getURI(), stmt.getObject().toString());
    }

    private static enum SELECT {
        BEST,
        BEST1TO1,
        BEST1TON,
        ALL;

    }

    private static enum DATASET_PART {
        SOURCE,
        TARGET;

    }
}

