/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class AuthorityConformationEnrichmentOperator
extends AbstractParameterizedEnrichmentOperator
implements ReverseLearnable,
SelfConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityConformationEnrichmentOperator.class);
    public static final Property SOURCE_AUTHORITY = DEER.property("sourceAuthority");
    public static final Property TARGET_AUTHORITY = DEER.property("targetAuthority");
    public static final Property OPERATION = DEER.property("operation");

    @Override
    public String getDescription() {
        return "Moves subject IRIs to another namespace";
    }

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(OPERATION).declareValidationShape(AuthorityConformationEnrichmentOperator.getValidationModelFor(AuthorityConformationEnrichmentOperator.class)).build();
    }

    protected List<Model> safeApply(List<Model> models) {
        Model model = models.get(0);
        Model conformModel = ModelFactory.createDefaultModel();
        HashMap authorityMapping = new HashMap();
        this.getParameterMap().listPropertyObjects(OPERATION).map(RDFNode::asResource).forEach(op -> {
            String source = op.getPropertyResourceValue(SOURCE_AUTHORITY).asResource().getURI();
            String target = op.getPropertyResourceValue(TARGET_AUTHORITY).asResource().getURI();
            authorityMapping.put(source, target);
        });
        model.listStatements().forEachRemaining(stmt -> {
            Resource subject = stmt.getSubject();
            for (String source : authorityMapping.keySet()) {
                if (Objects.equals(source, "") || !subject.getURI().startsWith(source)) continue;
                String conformedUri = subject.getURI().replaceFirst(source, (String)authorityMapping.get(source));
                subject = ResourceFactory.createResource((String)conformedUri);
                break;
            }
            conformModel.add(subject, stmt.getPredicate(), stmt.getObject());
        });
        return Lists.newArrayList((Object[])new Model[]{conformModel});
    }

    @Override
    public double predictApplicability(List<Model> inputs, Model target) {
        return this.learnParameterMap(inputs, target, null).listPropertyObjects(OPERATION).count() > 0L ? 1.0 : 0.0;
    }

    @Override
    public List<Model> reverseApply(List<Model> inputs, Model target) {
        ValidatableParameterMap reverseParameterMap = this.createParameterMap();
        this.learnParameterMap(inputs, target, null).listPropertyObjects(OPERATION).forEach(r -> reverseParameterMap.add(OPERATION, (RDFNode)reverseParameterMap.createResource().addProperty(SOURCE_AUTHORITY, (RDFNode)r.asResource().getPropertyResourceValue(TARGET_AUTHORITY)).addProperty(TARGET_AUTHORITY, (RDFNode)r.asResource().getPropertyResourceValue(SOURCE_AUTHORITY))));
        this.initParameters(reverseParameterMap.init());
        return this.safeApply(List.of(target));
    }

    @Override
    public ValidatableParameterMap learnParameterMap(List<Model> inputs, Model target, ValidatableParameterMap prototype) {
        String t;
        ValidatableParameterMap parameters = this.createParameterMap();
        String s = this.getMostRedundantUri(inputs.get(0));
        if (!Objects.equals(s, t = this.getMostRedundantUri(target))) {
            parameters.add(OPERATION, (RDFNode)parameters.createResource().addProperty(SOURCE_AUTHORITY, (RDFNode)parameters.createResource(s)).addProperty(TARGET_AUTHORITY, (RDFNode)parameters.createResource(t)));
        }
        return parameters.init();
    }

    @Override
    public ExecutionNode.DegreeBounds getLearnableDegreeBounds() {
        return this.getDegreeBounds();
    }

    private String getMostRedundantUri(Model m) {
        HashMultiset subjectsMultiset = HashMultiset.create();
        ResIterator listSubjects = m.listSubjects();
        while (listSubjects.hasNext()) {
            String authority = ((Resource)listSubjects.next()).toString();
            authority = authority.contains("#") ? authority.substring(0, authority.indexOf("#") + 1) : authority.substring(0, authority.lastIndexOf("/") + 1);
            subjectsMultiset.add((Object)ResourceFactory.createResource((String)authority));
        }
        String result = "";
        int max = 0;
        for (Resource r : subjectsMultiset) {
            int i = subjectsMultiset.count((Object)r);
            if (i <= max) continue;
            max = i;
            result = r.getURI();
        }
        return result;
    }
}

