/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.decorators;

import java.util.List;
import org.aksw.deer.DeerAnalyticsStore;
import org.aksw.deer.DeerExecutionNode;
import org.aksw.deer.ParameterizedDeerExecutionNode;
import org.aksw.deer.decorators.AbstractDeerExecutionNodeDecorator;
import org.aksw.deer.decorators.AbstractParameterizedDeerExecutionNodeDecorator;
import org.aksw.deer.decorators.AbstractParameterizedDeerExecutionNodeWrapper;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.FaradayCageContext;
import org.aksw.faraday_cage.engine.Parameterized;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.json.JSONObject;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class SparqlAnalyticsWrapper
extends AbstractParameterizedDeerExecutionNodeWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SparqlAnalyticsWrapper.class);
    public static final Property SPARQL_SELECT_QUERY = DEER.property("sparqlSelectQuery");
    public static final Property JSON_OUTPUT = DEER.property("jsonOutput");

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(SPARQL_SELECT_QUERY).declareProperty(JSON_OUTPUT).build();
    }

    private void applyTriggered(Resource id, List<Model> in, List<Model> out) {
        int i;
        Dataset dataset = DatasetFactory.createGeneral();
        for (i = 0; i < in.size(); ++i) {
            dataset.addNamedModel(DEER.resource("inputGraph" + i).getURI(), in.get(i));
        }
        for (i = 0; i < out.size(); ++i) {
            dataset.addNamedModel(DEER.resource("outputGraph" + i).getURI(), out.get(i));
        }
        String query = this.getParameterMap().get(SPARQL_SELECT_QUERY).asLiteral().getString();
        String[] jsonOutput = new String[]{this.getParameterMap().get(JSON_OUTPUT).asLiteral().getString()};
        QueryExecution queryExecution = QueryExecutionFactory.create((String)query, (Dataset)dataset);
        ResultSet resultSet = queryExecution.execSelect();
        List resultVars = resultSet.getResultVars();
        resultSet.forEachRemaining(qs -> resultVars.stream().filter(arg_0 -> ((QuerySolution)qs).contains(arg_0)).forEach(varName -> {
            jsonOutput[0] = jsonOutput[0].replace("?" + varName, "\"" + qs.get(varName).toString() + "\"");
        }));
        DeerAnalyticsStore.write(FaradayCageContext.getRunId(), id, new JSONObject(jsonOutput[0]));
        logger.info("AnalyticsWrapper {} keeping notes", (Object)this.getId());
    }

    public DeerExecutionNode wrap(DeerExecutionNode executionNode) {
        if (executionNode instanceof Parameterized) {
            return new ParameterizedSparqlAnalyticsDecorator((ParameterizedDeerExecutionNode)executionNode);
        }
        return new SparqlAnalyticsDecorator(executionNode);
    }

    @Override
    public String getDocumentationURL() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    private class ParameterizedSparqlAnalyticsDecorator
    extends AbstractParameterizedDeerExecutionNodeDecorator {
        public ParameterizedSparqlAnalyticsDecorator(ParameterizedDeerExecutionNode other) {
            super(other);
        }

        public List<Model> apply(List<Model> in) {
            List out = super.apply(in);
            SparqlAnalyticsWrapper.this.applyTriggered(((ParameterizedDeerExecutionNode)this.getWrapped()).getId(), in, out);
            return out;
        }
    }

    private class SparqlAnalyticsDecorator
    extends AbstractDeerExecutionNodeDecorator {
        public SparqlAnalyticsDecorator(ExecutionNode<Model> other) {
            super(other);
        }

        public List<Model> apply(List<Model> in) {
            List out = super.apply(in);
            SparqlAnalyticsWrapper.this.applyTriggered(this.getWrapped().getId(), in, out);
            return out;
        }
    }
}

