/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.List;
import org.aksw.deer.enrichments.EnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.genetic.AbstractMutator;
import org.aksw.deer.learning.genetic.Genotype;
import org.aksw.deer.learning.genetic.RandomOperatorFactory;
import org.apache.jena.rdf.model.Model;

public class SemanticMutator
extends AbstractMutator {
    @Override
    protected void mutateRow(Genotype g, int i) {
        double applicability2;
        double applicability1;
        List<EnrichmentOperator> all = RandomOperatorFactory.getAll();
        Model target = g.trainingData.getTrainingTarget();
        int[] count = new int[all.size()];
        double[] sum = new double[all.size()];
        for (int k = 0; k < all.size(); ++k) {
            EnrichmentOperator op = all.get(k);
            for (int j = g.getNumberOfInputs(); j < g.getSize(); ++j) {
                double applicability;
                List<Model> inputModels = g.getInputModels(j);
                if (inputModels.size() > op.getInDegree()) {
                    applicability1 = ((ReverseLearnable)((Object)op)).predictApplicability(List.of(inputModels.get(0)), target);
                    applicability2 = ((ReverseLearnable)((Object)op)).predictApplicability(List.of(inputModels.get(1)), target);
                    applicability = Math.max(applicability1, applicability2);
                } else {
                    applicability = inputModels.size() == op.getInDegree() ? ((ReverseLearnable)((Object)op)).predictApplicability(inputModels, target) : ((ReverseLearnable)((Object)op)).predictApplicability(List.of(inputModels.get(0), inputModels.get(0)), target);
                }
                if (!(applicability > 0.0)) continue;
                int n = k;
                sum[n] = sum[n] + (applicability > 1.0 ? 1.0 : applicability);
                int n2 = k;
                count[n2] = count[n2] + 1;
            }
        }
        double bestScore = Double.NEGATIVE_INFINITY;
        int bestK = 0;
        for (int k = 0; k < all.size(); ++k) {
            double score = sum[k] - (double)count[k];
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestK = k;
        }
        EnrichmentOperator newOp = all.get(bestK);
        List<Integer> inputs = g.getInputs(i);
        if (inputs.size() > newOp.getInDegree()) {
            List<Model> inputModels = g.getInputModels(i);
            applicability1 = ((ReverseLearnable)((Object)newOp)).predictApplicability(List.of(inputModels.get(0)), target);
            if (applicability1 > (applicability2 = ((ReverseLearnable)((Object)newOp)).predictApplicability(List.of(inputModels.get(1)), target))) {
                g.addRow(i, newOp, new int[]{1, 1, inputs.get(0), 0});
            } else {
                g.addRow(i, newOp, new int[]{1, 1, inputs.get(1), 0});
            }
        } else if (inputs.size() < newOp.getInDegree()) {
            g.addRow(i, newOp, new int[]{2, 1, inputs.get(0), 0, inputs.get(0), 0});
        } else if (inputs.size() == 2) {
            g.addRow(i, newOp, new int[]{2, 1, inputs.get(0), 0, inputs.get(1), 0});
        } else {
            g.addRow(i, newOp, new int[]{1, 1, inputs.get(0), 0});
        }
    }
}

