/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.deer.enrichments.AuthorityConformationEnrichmentOperator;
import org.aksw.deer.enrichments.DereferencingEnrichmentOperator;
import org.aksw.deer.enrichments.EnrichmentOperator;
import org.aksw.deer.enrichments.FilterEnrichmentOperator;
import org.aksw.deer.enrichments.LinkingEnrichmentOperator;
import org.aksw.deer.enrichments.MergeEnrichmentOperator;
import org.aksw.deer.enrichments.NEREnrichmentOperator;
import org.aksw.deer.enrichments.PredicateConformationEnrichmentOperator;
import org.aksw.deer.learning.Learnable;
import org.aksw.deer.learning.RandomUtil;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.deer.vocabulary.DEERA;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.Parameterized;
import org.aksw.faraday_cage.engine.PluginFactory;
import org.aksw.faraday_cage.vocabulary.FCAGE;
import org.apache.jena.rdf.model.Resource;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginManager;

public class RandomOperatorFactory {
    private static PluginFactory<EnrichmentOperator> factory = new PluginFactory(EnrichmentOperator.class, (PluginManager)new DefaultPluginManager(), FCAGE.ExecutionNode);
    private static Set<Resource> allowedTypes = new HashSet<Resource>(List.of(new LinkingEnrichmentOperator().getType(), new NEREnrichmentOperator().getType(), new PredicateConformationEnrichmentOperator().getType(), new AuthorityConformationEnrichmentOperator().getType(), new FilterEnrichmentOperator().getType(), new MergeEnrichmentOperator().getType(), new DereferencingEnrichmentOperator().getType()));
    private static List<Resource> availableOps;
    private static int maxArity;
    private static Map<Integer, List<Resource>> arityOpsMap;

    private RandomOperatorFactory() {
    }

    private static void setup() {
        arityOpsMap = new HashMap<Integer, List<Resource>>();
        availableOps = new ArrayList<Resource>();
        factory.listAvailable().stream().filter(allowedTypes::contains).map(arg_0 -> factory.getImplementationOf(arg_0)).filter(op -> op instanceof Learnable && (!(op instanceof Parameterized) || op instanceof SelfConfigurable)).filter(op -> ((Learnable)((Object)op)).getLearnableDegreeBounds().minOut() == 1).forEach(op -> {
            availableOps.add(op.getType());
            ExecutionNode.DegreeBounds degreeBounds = ((Learnable)((Object)op)).getLearnableDegreeBounds();
            for (int i = degreeBounds.minIn(); i <= degreeBounds.maxIn(); ++i) {
                if (i > maxArity) {
                    maxArity = i;
                }
                if (!arityOpsMap.containsKey(i)) {
                    arityOpsMap.put(i, new ArrayList());
                }
                arityOpsMap.get(i).add(op.getType());
            }
        });
    }

    public static void setAllowedTypes(Set<Resource> allowedTypes) {
        RandomOperatorFactory.allowedTypes = allowedTypes;
        RandomOperatorFactory.setup();
    }

    public static void setFactory(PluginFactory<EnrichmentOperator> factory) {
        RandomOperatorFactory.factory = factory;
        RandomOperatorFactory.setup();
    }

    public static List<EnrichmentOperator> getAll() {
        return allowedTypes.stream().map(arg_0 -> factory.getImplementationOf(arg_0)).peek(op -> op.initDegrees(((Learnable)((Object)op)).getLearnableDegreeBounds().minIn(), 1)).peek(op -> op.initPluginId(DEERA.forExecutionNode(op))).collect(Collectors.toList());
    }

    public static EnrichmentOperator getForMaxArity(int arity) {
        EnrichmentOperator op;
        if (!arityOpsMap.containsKey(arity)) {
            throw new IllegalArgumentException("There are no available operators with in degree = " + arity + " and out degree = 1");
        }
        while (arity < ((Learnable)((Object)(op = (EnrichmentOperator)factory.getImplementationOf(availableOps.get(RandomUtil.get(availableOps.size())))))).getLearnableDegreeBounds().minIn()) {
        }
        op.initPluginId(DEERA.forExecutionNode(op));
        return op;
    }

    public static EnrichmentOperator getForArity(int arity) {
        if (!arityOpsMap.containsKey(arity)) {
            throw new IllegalArgumentException("There are no available operators with in degree = " + arity + " and out degree = 1");
        }
        List<Resource> bucket = arityOpsMap.get(arity);
        EnrichmentOperator op = (EnrichmentOperator)factory.getImplementationOf(bucket.get(RandomUtil.get(bucket.size())));
        op.initPluginId(DEERA.forExecutionNode(op));
        op.initDegrees(arity, 1);
        return op;
    }

    public static EnrichmentOperator reproduce(EnrichmentOperator op) {
        EnrichmentOperator clone = (EnrichmentOperator)factory.getImplementationOf(op.getType());
        clone.initPluginId(op.getId());
        return clone;
    }

    public static int getMaxArity() {
        return maxArity;
    }

    static {
        maxArity = 0;
        RandomOperatorFactory.setup();
    }
}

