/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import org.aksw.deer.learning.genetic.Genotype;

class PopulationEvaluationResult {
    private Genotype best;
    private double min;
    private double max;
    private double average;
    private double standardDeviation;

    PopulationEvaluationResult(List<Genotype> individuals) {
        this.best = individuals.stream().max(Comparator.comparingDouble(Genotype::getBestFitness)).orElseThrow();
        DoubleStatistics statistics = individuals.stream().mapToDouble(Genotype::getBestFitness).collect(DoubleStatistics::new, DoubleStatistics::accept, DoubleStatistics::combine);
        this.min = statistics.getMin();
        this.max = statistics.getMax();
        this.average = statistics.getAverage();
        this.standardDeviation = statistics.getStandardDeviation();
    }

    public Genotype getBest() {
        return this.best;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getAverage() {
        return this.average;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    static class DoubleStatistics
    extends DoubleSummaryStatistics {
        private double sumOfSquare = 0.0;
        private double sumOfSquareCompensation;
        private double simpleSumOfSquare;

        DoubleStatistics() {
        }

        @Override
        public void accept(double value) {
            super.accept(value);
            double squareValue = value * value;
            this.simpleSumOfSquare += squareValue;
            this.sumOfSquareWithCompensation(squareValue);
        }

        public DoubleStatistics combine(DoubleStatistics other) {
            super.combine(other);
            this.simpleSumOfSquare += other.simpleSumOfSquare;
            this.sumOfSquareWithCompensation(other.sumOfSquare);
            this.sumOfSquareWithCompensation(other.sumOfSquareCompensation);
            return this;
        }

        private void sumOfSquareWithCompensation(double value) {
            double tmp = value - this.sumOfSquareCompensation;
            double velvel = this.sumOfSquare + tmp;
            this.sumOfSquareCompensation = velvel - this.sumOfSquare - tmp;
            this.sumOfSquare = velvel;
        }

        public double getSumOfSquare() {
            double tmp = this.sumOfSquare + this.sumOfSquareCompensation;
            if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSumOfSquare)) {
                return this.simpleSumOfSquare;
            }
            return tmp;
        }

        public final double getStandardDeviation() {
            return this.getCount() > 0L ? Math.sqrt(this.getSumOfSquare() / (double)this.getCount() - Math.pow(this.getAverage(), 2.0)) : 0.0;
        }
    }
}

