/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.io;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.aksw.deer.io.AbstractModelReader;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class EmbeddedModelReader
extends AbstractModelReader {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedModelReader.class);
    public static final Property EMBEDDED_MODEL = DEER.property("embeddedModel");
    public static final Property SERIALIZATION_FORMAT = DEER.property("serializationFormat");
    public static final Property IMPORT_PREFIXES = DEER.property("importPrefixes");

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(EMBEDDED_MODEL).declareProperty(SERIALIZATION_FORMAT).build();
    }

    protected List<Model> safeApply(List<Model> data) {
        String embeddedModel = this.getParameterMap().get(EMBEDDED_MODEL).asLiteral().getString();
        String serializationFormat = this.getParameterMap().getOptional(SERIALIZATION_FORMAT).map(RDFNode::asLiteral).map(Literal::getString).orElse("TTL");
        boolean importPrefixes = this.getParameterMap().getOptional(SERIALIZATION_FORMAT).map(RDFNode::asLiteral).map(Literal::getBoolean).orElse(true);
        Model result = ModelFactory.createDefaultModel();
        result.read((Reader)new StringReader(embeddedModel), null, serializationFormat);
        return List.of(result);
    }
}

