/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.deer.vocabulary.FOXO;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ThreadlocalInheritingCompletableFuture;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.aksw.fox.binding.FoxApi;
import org.aksw.fox.binding.FoxParameter;
import org.aksw.fox.binding.IFoxApi;
import org.aksw.fox.data.Entity;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class NEREnrichmentOperator
extends AbstractParameterizedEnrichmentOperator
implements SelfConfigurable,
ReverseLearnable {
    public static final Property LITERAL_PROPERTY = DEER.property("literalProperty");
    public static final Property IMPORT_PROPERTY = DEER.property("importProperty");
    public static final Property FOX_URL = DEER.property("foxUrl");
    public static final Property NE_TYPE = DEER.property("neType");
    public static final Property PARALLELISM = DEER.property("parallelism");
    private static final String DEFAULT_FOX_URL = "http://localhost:4444/fox";
    private static final Property DEFAULT_IMPORT_PROPERTY = ResourceFactory.createProperty((String)"http://geoknow.org/ontology/relatedTo");
    private static final int DEFAULT_PARALLELISM = 1;
    private static final Logger logger = LoggerFactory.getLogger(NEREnrichmentOperator.class);
    private static final ConcurrentMap<NEROperationID, CompletableFuture<List<String>>> cache = new ConcurrentHashMap<NEROperationID, CompletableFuture<List<String>>>();
    private Property literalProperty;
    private Property importProperty;
    private URL foxUri;
    private int parallelism;
    private NET neType;

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(LITERAL_PROPERTY).declareProperty(IMPORT_PROPERTY).declareProperty(FOX_URL).declareProperty(NE_TYPE).declareValidationShape(NEREnrichmentOperator.getValidationModelFor(NEREnrichmentOperator.class)).declareValidationShape(NEREnrichmentOperator.getValidationModelFor(NEREnrichmentOperator.class)).build();
    }

    private void initializeFields() {
        ValidatableParameterMap parameters = this.getParameterMap();
        this.literalProperty = parameters.getOptional(LITERAL_PROPERTY).map(n -> (Property)n.as(Property.class)).orElse(null);
        this.importProperty = parameters.getOptional(IMPORT_PROPERTY).map(n -> (Property)n.as(Property.class)).orElse(DEFAULT_IMPORT_PROPERTY);
        try {
            String urlString = parameters.getOptional(FOX_URL).map(RDFNode::asResource).map(Resource::getURI).orElse(DEFAULT_FOX_URL);
            this.foxUri = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Encountered bad URL in " + this.getId() + "!", e);
        }
        this.neType = parameters.getOptional(NE_TYPE).map(RDFNode::asLiteral).map(l -> l.getString().toUpperCase()).map(NET::valueOf).orElse(NET.ALL);
        this.parallelism = parameters.getOptional(PARALLELISM).map(RDFNode::asLiteral).map(Literal::getInt).orElse(1);
    }

    protected List<Model> safeApply(List<Model> models) {
        this.initializeFields();
        Model model = models.get(0);
        Model resultModel = ModelFactory.createDefaultModel();
        resultModel.add(model);
        if (this.literalProperty == null) {
            this.literalProperty = LiteralPropertyRanker.getTopRankedProperty(model);
        }
        Object future = new ThreadlocalInheritingCompletableFuture();
        ArrayList<CompletionStage> pool = new ArrayList<CompletionStage>(this.parallelism);
        for (int z = 0; z < this.parallelism; ++z) {
            pool.add(z == 0 ? future.thenApply(x -> x) : future.thenApplyAsync(x -> x));
        }
        AtomicInteger i = new AtomicInteger(0);
        model.listStatements(null, this.literalProperty, (RDFNode)null).filterKeep(statement -> statement.getObject().isLiteral()).forEachRemaining(statement -> {
            i.compareAndSet(this.parallelism, 0);
            int j = i.getAndIncrement();
            Resource subject = statement.getSubject();
            pool.set(j, ((CompletableFuture)pool.get(j)).thenRun(() -> {
                Model result = null;
                switch (this.neType) {
                    case ALL: {
                        result = this.runFOX(subject, statement.getObject().asLiteral().getString(), null);
                        break;
                    }
                    case LOCATION: {
                        result = this.runFOX(subject, statement.getObject().asLiteral().toString(), FOXO.LOCATION.getURI());
                        break;
                    }
                    case PERSON: {
                        result = this.runFOX(subject, statement.getObject().asLiteral().toString(), FOXO.PERSON.getURI());
                        break;
                    }
                    case ORGANIZATION: {
                        result = this.runFOX(subject, statement.getObject().asLiteral().toString(), FOXO.ORGANIZATION.getURI());
                    }
                }
                resultModel.enterCriticalSection(false);
                try {
                    resultModel.add(result);
                }
                finally {
                    resultModel.leaveCriticalSection();
                }
            }));
        });
        future.complete(null);
        for (int z = 0; z < this.parallelism; ++z) {
            future = future.thenCombine((CompletionStage)pool.get(z), (a, b) -> null);
        }
        future.join();
        return Lists.newArrayList((Object[])new Model[]{resultModel});
    }

    private Model runFOX(Resource subject, String input, String type) {
        List<String> result;
        NEROperationID key = new NEROperationID(this.foxUri, input, type);
        ThreadlocalInheritingCompletableFuture future = new ThreadlocalInheritingCompletableFuture();
        cache.putIfAbsent(key, (CompletableFuture<List<String>>)future);
        if (cache.get(key) != future) {
            try {
                result = (List<String>)((CompletableFuture)cache.get(key)).get();
            }
            catch (InterruptedException | ExecutionException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            IFoxApi fox = new FoxApi().setApiURL(this.foxUri).setTask(FoxParameter.TASK.NER).setOutputFormat(FoxParameter.OUTPUT.TURTLE).setLang(FoxParameter.LANG.EN).setInput(input).setLightVersion(FoxParameter.FOXLIGHT.ENBalie).send();
            result = fox.responseAsClasses().getEntities().stream().filter(e -> Optional.ofNullable(type).isEmpty() || e.getType().equals(type)).map(Entity::getUri).collect(Collectors.toList());
            future.complete(result);
        }
        Model namedEntityModel = ModelFactory.createDefaultModel();
        result.forEach(e -> namedEntityModel.add(subject, this.importProperty, (RDFNode)namedEntityModel.createResource(e)));
        return namedEntityModel;
    }

    @Override
    public double predictApplicability(List<Model> inputs, Model target) {
        if (target.contains(null, FOXO.RELATED_TO) && !inputs.get(0).contains(null, FOXO.RELATED_TO)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public List<Model> reverseApply(List<Model> inputs, Model target) {
        Model result = ModelFactory.createDefaultModel().add(target);
        result.removeAll(null, FOXO.RELATED_TO, null);
        return List.of(result);
    }

    @Override
    public ValidatableParameterMap learnParameterMap(List<Model> inputs, Model target, ValidatableParameterMap prototype) {
        return this.createParameterMap().add(LITERAL_PROPERTY, (RDFNode)RDFS.comment).add(IMPORT_PROPERTY, (RDFNode)FOXO.RELATED_TO).add(NE_TYPE, (RDFNode)ResourceFactory.createStringLiteral((String)"all")).add(FOX_URL, (RDFNode)ResourceFactory.createResource((String)DEFAULT_FOX_URL)).add(PARALLELISM, (RDFNode)ResourceFactory.createTypedLiteral((Object)1)).init();
    }

    @Override
    public ExecutionNode.DegreeBounds getLearnableDegreeBounds() {
        return this.getDegreeBounds();
    }

    private static enum NET {
        ORGANIZATION,
        LOCATION,
        PERSON,
        ALL;

    }

    private static class LiteralPropertyRanker {
        private LiteralPropertyRanker() {
        }

        static SortedMap<Double, Property> rank(Model model) {
            TreeMap<Double, Property> propertyRanks = new TreeMap<Double, Property>(Collections.reverseOrder());
            model.listStatements().mapWith(Statement::getPredicate).forEachRemaining(property -> {
                AtomicLong totalLitSize = new AtomicLong(1L);
                AtomicLong totalLitCount = new AtomicLong(0L);
                model.listObjectsOfProperty(property).filterKeep(RDFNode::isLiteral).mapWith(RDFNode::asLiteral).forEachRemaining(l -> {
                    totalLitCount.getAndIncrement();
                    totalLitSize.addAndGet(l.toString().length());
                });
                double avgLitSize = (double)totalLitSize.get() / (double)totalLitCount.get();
                propertyRanks.put(avgLitSize, (Property)property);
            });
            return propertyRanks;
        }

        static Property getTopRankedProperty(Model model) {
            SortedMap<Double, Property> ranks = LiteralPropertyRanker.rank(model);
            return (Property)ranks.get(ranks.firstKey());
        }
    }

    private static class NEROperationID {
        private URL foxURL;
        private String input;
        private String type;

        private NEROperationID(URL foxURL, String input, String type) {
            this.foxURL = foxURL;
            this.input = input;
            this.type = type;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.foxURL.toString()).append((Object)this.input).append((Object)this.type).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NEROperationID) {
                NEROperationID o = (NEROperationID)obj;
                return new EqualsBuilder().append((Object)this.foxURL, (Object)o.foxURL).append((Object)this.input, (Object)o.input).append((Object)this.type, (Object)o.type).isEquals();
            }
            return false;
        }
    }
}

