/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import java.util.List;
import org.aksw.deer.enrichments.AbstractEnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.pf4j.Extension;

@Extension
public class MergeEnrichmentOperator
extends AbstractEnrichmentOperator
implements ReverseLearnable {
    protected List<Model> safeApply(List<Model> models) {
        Model merge = ModelFactory.createDefaultModel();
        for (Model model : models) {
            merge.add(model);
        }
        return List.of(merge);
    }

    @Override
    public ExecutionNode.DegreeBounds getDegreeBounds() {
        return new ExecutionNode.DegreeBounds(2, Integer.MAX_VALUE, 1, 1);
    }

    @Override
    public double predictApplicability(List<Model> inputs, Model target) {
        Model sI = inputs.get(0);
        Model tI = inputs.get(1);
        if (inputs.size() == 1) {
            return 0.0;
        }
        double[] score = new double[2];
        int size = target.listStatements().filterDrop(stmt -> stmt.getObject().isAnon() && stmt.getSubject().isAnon()).mapWith(stmt -> {
            boolean sInS = sI.containsResource((RDFNode)stmt.getSubject());
            boolean sInT = tI.containsResource((RDFNode)stmt.getSubject());
            boolean oInS = sI.containsResource(stmt.getObject());
            boolean oInT = tI.containsResource(stmt.getObject());
            score[0] = score[0] + this.getScore(sInS, sInT, oInS, oInT);
            score[1] = score[1] + this.getScore(sInT, sInS, oInT, oInS);
            return stmt;
        }).toList().size();
        return (score[0] + score[1]) / (double)size;
    }

    private double getScore(boolean sInS, boolean sInT, boolean oInS, boolean oInT) {
        if (sInS && oInS && !sInT && !oInT) {
            return 1.0;
        }
        if ((sInS || oInS) && !sInT && !oInT) {
            return 0.75;
        }
        if (sInS && oInS) {
            return 0.5;
        }
        if (sInS || oInS) {
            return 0.25;
        }
        return 0.0;
    }

    @Override
    public List<Model> reverseApply(List<Model> inputs, Model target) {
        Model sI = inputs.get(0);
        Model tI = inputs.get(1);
        Model s = ModelFactory.createDefaultModel();
        Model t = ModelFactory.createDefaultModel();
        target.listStatements().filterDrop(stmt -> stmt.getObject().isAnon() && stmt.getSubject().isAnon()).forEachRemaining(stmt -> {
            double inTScore;
            boolean oInT;
            boolean oInS;
            boolean sInT;
            boolean sInS = sI.containsResource((RDFNode)stmt.getSubject());
            double inSScore = this.getScore(sInS, sInT = tI.containsResource((RDFNode)stmt.getSubject()), oInS = sI.containsResource(stmt.getObject()), oInT = tI.containsResource(stmt.getObject()));
            if (inSScore >= (inTScore = this.getScore(sInT, sInS, oInT, oInS))) {
                s.add(stmt);
            }
            if (inTScore >= inSScore) {
                t.add(stmt);
            }
        });
        return List.of(s, t);
    }

    @Override
    public ExecutionNode.DegreeBounds getLearnableDegreeBounds() {
        return new ExecutionNode.DegreeBounds(2, 2, 1, 1);
    }
}

