/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import java.util.List;
import java.util.Optional;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.Statement;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class FilterEnrichmentOperator
extends AbstractParameterizedEnrichmentOperator
implements ReverseLearnable,
SelfConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(FilterEnrichmentOperator.class);
    public static final Property SUBJECT = DEER.property("subject");
    public static final Property PREDICATE = DEER.property("predicate");
    public static final Property OBJECT = DEER.property("object");
    public static final Property SELECTOR = DEER.property("selector");
    public static final Property SPARQL_CONSTRUCT_QUERY = DEER.property("sparqlConstructQuery");

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(SELECTOR).declareProperty(SPARQL_CONSTRUCT_QUERY).declareValidationShape(FilterEnrichmentOperator.getValidationModelFor(FilterEnrichmentOperator.class)).build();
    }

    protected List<Model> safeApply(List<Model> models) {
        return List.of(this.filterModel(models.get(0)));
    }

    private Model filterModel(Model model) {
        Model resultModel = ModelFactory.createDefaultModel();
        Optional sparqlQuery = this.getParameterMap().getOptional(SPARQL_CONSTRUCT_QUERY);
        if (sparqlQuery.isPresent()) {
            logger.info("Executing SPARQL CONSTRUCT query for " + this.getId() + " ...");
            return QueryExecutionFactory.create((String)((RDFNode)sparqlQuery.get()).asLiteral().getString(), (Model)model).execConstruct();
        }
        this.getParameterMap().listPropertyObjects(SELECTOR).map(RDFNode::asResource).forEach(selectorResource -> {
            Resource s = selectorResource.getPropertyResourceValue(SUBJECT);
            Resource p = selectorResource.getPropertyResourceValue(PREDICATE);
            Resource o = selectorResource.getPropertyResourceValue(OBJECT);
            logger.info("Running filter " + this.getId() + " for triple pattern {} {} {} ...", new Object[]{s == null ? "[]" : "<" + s.asResource().getURI() + ">", p == null ? "[]" : "<" + p.asResource().getURI() + ">", o == null ? "[]" : "(<)(\")" + o.toString() + "(\")(>)"});
            SimpleSelector selector = new SimpleSelector(s == null ? null : s.asResource(), p == null ? null : (Property)p.as(Property.class), (RDFNode)o);
            resultModel.add(model.listStatements((Selector)selector));
        });
        return resultModel;
    }

    @Override
    public double predictApplicability(List<Model> inputs, Model target) {
        Model in = inputs.get(0);
        double propertyIntersectionSize = target.listStatements().mapWith(Statement::getPredicate).filterKeep(p -> in.contains(null, p)).toList().size();
        double stmtIntersectionSize = target.listStatements().filterKeep(arg_0 -> ((Model)in).contains(arg_0)).toList().size();
        double propertyRecall = propertyIntersectionSize / (double)target.size();
        double stmtRecall = stmtIntersectionSize / (double)target.size();
        return stmtRecall * 0.6 + propertyRecall * 0.3 + (double)(in.size() - target.size()) / (double)in.size() * 0.1;
    }

    @Override
    public List<Model> reverseApply(List<Model> inputs, Model target) {
        return List.of(ModelFactory.createDefaultModel().add(target).add(inputs.get(0)));
    }

    @Override
    public ValidatableParameterMap learnParameterMap(List<Model> inputs, Model target, ValidatableParameterMap prototype) {
        ValidatableParameterMap result = this.createParameterMap();
        Model in = inputs.get(0);
        target.listStatements().mapWith(Statement::getPredicate).filterKeep(p -> in.contains(null, p)).toSet().forEach(p -> result.add(SELECTOR, (RDFNode)result.createResource().addProperty(PREDICATE, (RDFNode)p)));
        return result.init();
    }

    @Override
    public ExecutionNode.DegreeBounds getLearnableDegreeBounds() {
        return this.getDegreeBounds();
    }
}

