/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.deer.vocabulary.DBR;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.ThreadlocalInheritingCompletableFuture;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.apache.commons.collections15.MultiMap;
import org.apache.commons.collections15.multimap.MultiHashMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DereferencingEnrichmentOperator
extends AbstractParameterizedEnrichmentOperator
implements ReverseLearnable,
SelfConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(DereferencingEnrichmentOperator.class);
    public static final Property LOOKUP_PROPERTY = DEER.property("lookUpProperty");
    public static final Property LOOKUP_PREFIX = DEER.property("lookUpPrefix");
    public static final Property DEREFERENCING_PROPERTY = DEER.property("dereferencingProperty");
    public static final Property IMPORT_PROPERTY = DEER.property("importProperty");
    public static final Property OPERATION = DEER.property("operation");
    public static final Property USE_SPARQL_ENDPOINT = DEER.property("useSparqlEndpoint");
    private static String DEFAULT_LOOKUP_PREFIX = DBR.getURI();
    private HashMap<OperationGroup, Set<Property[]>> operations;
    private Optional<String> endpoint;
    private Model model;
    private static final ConcurrentMap<Resource, CompletableFuture<Model>> cache = new ConcurrentHashMap<Resource, CompletableFuture<Model>>();

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(OPERATION).declareProperty(USE_SPARQL_ENDPOINT).declareValidationShape(DereferencingEnrichmentOperator.getValidationModelFor(DereferencingEnrichmentOperator.class)).build();
    }

    public void initializeOperations() {
        ValidatableParameterMap parameters = this.getParameterMap();
        this.operations = new HashMap();
        parameters.listPropertyObjects(OPERATION).map(RDFNode::asResource).forEach(op -> {
            String lookUpPrefix = !op.hasProperty(LOOKUP_PREFIX) ? DEFAULT_LOOKUP_PREFIX : op.getProperty(LOOKUP_PREFIX).getLiteral().getString();
            Property lookUpProperty = !op.hasProperty(LOOKUP_PROPERTY) ? null : (Property)op.getPropertyResourceValue(LOOKUP_PROPERTY).as(Property.class);
            Property dereferencingProperty = !op.hasProperty(DEREFERENCING_PROPERTY) ? null : (Property)op.getPropertyResourceValue(DEREFERENCING_PROPERTY).as(Property.class);
            Property importProperty = !op.hasProperty(IMPORT_PROPERTY) ? dereferencingProperty : (Property)op.getPropertyResourceValue(IMPORT_PROPERTY).as(Property.class);
            OperationGroup opGroup = new OperationGroup(lookUpProperty, lookUpPrefix);
            if (!this.operations.containsKey(opGroup)) {
                this.operations.put(opGroup, new HashSet());
            }
            this.operations.get(opGroup).add(new Property[]{dereferencingProperty, importProperty});
        });
    }

    protected List<Model> safeApply(List<Model> models) {
        this.endpoint = this.getParameterMap().getOptional(USE_SPARQL_ENDPOINT).map(r -> r.asResource().getURI());
        this.initializeOperations();
        this.model = ModelFactory.createDefaultModel().add(models.get(0));
        this.operations.forEach(this.endpoint.isPresent() ? this::runSPARQLOperation : this::runOperation);
        return Lists.newArrayList((Object[])new Model[]{this.model});
    }

    private void runOperation(OperationGroup opGroup, Set<Property[]> ops) {
        HashMap dereffedPerResource = new HashMap();
        MultiMap<Resource, Resource> candidateNodes = this.getCandidateNodeMap(opGroup.lookupPrefix, opGroup.lookupProperty);
        candidateNodes.keySet().forEach(o -> dereffedPerResource.put(o, this.getEnrichmentPairsFor((Resource)o, ops)));
        for (Map.Entry entry : candidateNodes.entrySet()) {
            for (Resource subject : (Collection)entry.getValue()) {
                for (Pair pair : (List)dereffedPerResource.get(entry.getKey())) {
                    subject.addProperty((Property)pair.getLeft(), (RDFNode)pair.getRight());
                }
            }
        }
    }

    private void runSPARQLOperation(OperationGroup opGroup, Set<Property[]> ops) {
        String queryStart = "SELECT ?source ?import ?dereffed WHERE { VALUES (?source ?deref ?import) { ";
        String queryEnd = "} ?source ?deref ?dereffed . }";
        MultiMap<Resource, Resource> candidateNodes = this.getCandidateNodeMap(opGroup.lookupPrefix, opGroup.lookupProperty);
        int i = 0;
        int c = 0;
        int j = 0;
        StringBuilder sparqlQueryBuilder = new StringBuilder();
        for (Resource o : candidateNodes.keySet()) {
            ++i;
            for (Property[] op : ops) {
                sparqlQueryBuilder.append("(<");
                sparqlQueryBuilder.append(o.asResource().getURI());
                sparqlQueryBuilder.append("> <");
                sparqlQueryBuilder.append(op[0]);
                sparqlQueryBuilder.append("> <");
                sparqlQueryBuilder.append(op[1]);
                sparqlQueryBuilder.append(">)\n");
                if (++c <= 1000) continue;
                j += this.queryAndAddToModel(queryStart + sparqlQueryBuilder.toString() + queryEnd, candidateNodes);
                c = 0;
                sparqlQueryBuilder = new StringBuilder();
            }
        }
        if (c > 0) {
            this.queryAndAddToModel(queryStart + sparqlQueryBuilder.toString() + queryEnd, candidateNodes);
        }
        logger.info("Dereferenced {} of {} possible properties for lookup {}", new Object[]{j, i * ops.size(), opGroup});
    }

    private int queryAndAddToModel(String query, MultiMap<Resource, Resource> candidateNodes) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(this.endpoint.get());
        QueryExecution queryExecution = qef.createQueryExecution(query);
        ResultSet resultSet = queryExecution.execSelect();
        AtomicInteger i = new AtomicInteger(0);
        resultSet.forEachRemaining(result -> {
            i.incrementAndGet();
            for (Resource subject : candidateNodes.get((Object)result.getResource("?source"))) {
                subject.addProperty(this.model.createProperty(result.getResource("?import").getURI()), result.get("?dereffed"));
            }
        });
        queryExecution.close();
        return i.get();
    }

    private List<Pair<Property, RDFNode>> getEnrichmentPairsFor(Resource o, Set<Property[]> ops) {
        ArrayList<Pair<Property, RDFNode>> result = new ArrayList<Pair<Property, RDFNode>>();
        Model resourceModel = this.queryResourceModel(o);
        for (Property[] op : ops) {
            resourceModel.listStatements(o, op[0], (RDFNode)null).mapWith(Statement::getObject).forEachRemaining(x -> result.add((Pair<Property, RDFNode>)new ImmutablePair((Object)op[1], x)));
        }
        return result;
    }

    private Model queryResourceModel(Resource o) {
        URL url;
        ThreadlocalInheritingCompletableFuture future = new ThreadlocalInheritingCompletableFuture();
        cache.putIfAbsent(o, (CompletableFuture<Model>)future);
        if (cache.get(o) != future) {
            logger.debug("cached future for " + o.getURI());
            try {
                return (Model)((CompletableFuture)cache.get(o)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug("no cache for " + o.getURI());
        Model result = ModelFactory.createDefaultModel();
        try {
            url = new URL(o.getURI());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            future.complete(result);
            return result;
        }
        try {
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Accept", "application/rdf+xml");
            conn.setRequestProperty("Accept-Language", "en");
            result.read(conn.getInputStream(), null);
        }
        catch (ConnectException e) {
            if (e.getMessage().contains("refused")) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        future.complete(result);
        return result;
    }

    private MultiMap<Resource, Resource> getCandidateNodeMap(String lookupPrefix, Property lookUpProperty) {
        MultiHashMap result = new MultiHashMap();
        this.model.listStatements().filterKeep(statement -> statement.getObject().isURIResource() && statement.getObject().asResource().getURI().startsWith(lookupPrefix) && (lookUpProperty == null || statement.getPredicate().equals(lookUpProperty))).forEachRemaining(arg_0 -> DereferencingEnrichmentOperator.lambda$getCandidateNodeMap$6((MultiMap)result, arg_0));
        return result;
    }

    @Override
    public double predictApplicability(List<Model> inputs, Model target) {
        return this.learnParameterMap(inputs, target, null).listPropertyObjects(OPERATION).count() > 0L ? 1.0 : 0.0;
    }

    @Override
    public List<Model> reverseApply(List<Model> inputs, Model target) {
        Model result = ModelFactory.createDefaultModel();
        Set predicatesForDeletion = this.learnParameterMap(inputs, target, null).listPropertyObjects(OPERATION).map(n -> n.asResource().getPropertyResourceValue(DEREFERENCING_PROPERTY)).collect(Collectors.toSet());
        target.listStatements().filterDrop(stmt -> stmt.getSubject().getURI().startsWith(DEFAULT_LOOKUP_PREFIX) && predicatesForDeletion.contains(stmt.getPredicate())).forEachRemaining(arg_0 -> ((Model)result).add(arg_0));
        return List.of(result);
    }

    @Override
    public ValidatableParameterMap learnParameterMap(List<Model> inputs, Model target, ValidatableParameterMap prototype) {
        Model in = inputs.get(0);
        ValidatableParameterMap result = this.createParameterMap();
        target.listStatements().filterDrop(stmt -> stmt.getObject().isLiteral()).mapWith(Statement::getResource).filterKeep(r -> r.getURI().startsWith(DEFAULT_LOOKUP_PREFIX)).forEachRemaining(r -> target.listStatements(r, null, (RDFNode)null).filterDrop(stmt -> in.contains(r, stmt.getPredicate(), (RDFNode)null)).mapWith(Statement::getPredicate).toSet().forEach(p -> result.add(OPERATION, (RDFNode)result.createResource().addProperty(LOOKUP_PREFIX, DEFAULT_LOOKUP_PREFIX).addProperty(DEREFERENCING_PROPERTY, (RDFNode)p))));
        return result.init();
    }

    @Override
    public ExecutionNode.DegreeBounds getLearnableDegreeBounds() {
        return this.getDegreeBounds();
    }

    static void setDefaultLookupPrefix(String defaultLookupPrefix) {
        DEFAULT_LOOKUP_PREFIX = defaultLookupPrefix;
    }

    private static /* synthetic */ void lambda$getCandidateNodeMap$6(MultiMap result, Statement stmt) {
        result.put((Object)stmt.getResource(), (Object)stmt.getSubject());
    }

    private static class OperationGroup {
        private final Property lookupProperty;
        private final String lookupPrefix;

        private OperationGroup(Property lookupProperty, String lookupPrefix) {
            this.lookupProperty = lookupProperty;
            this.lookupPrefix = lookupPrefix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OperationGroup)) {
                return false;
            }
            OperationGroup other = (OperationGroup)obj;
            return Objects.equals(this.lookupPrefix, other.lookupPrefix) && Objects.equals(this.lookupProperty, other.lookupProperty);
        }

        public int hashCode() {
            return (this.lookupPrefix == null ? -1 : this.lookupPrefix.hashCode()) + 13 * (this.lookupProperty == null ? -1 : this.lookupProperty.hashCode());
        }

        public String toString() {
            return "(lookupPrefix: " + this.lookupPrefix + (String)(this.lookupProperty == null ? "" : ", lookupProperty: " + this.lookupProperty) + ")";
        }
    }
}

