/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Resource;
import org.json.JSONException;
import org.json.JSONObject;

public class DeerAnalyticsStore {
    private static Map<String, JSONObject> backend = new HashMap<String, JSONObject>();

    public static synchronized void write(String jobId, Resource nodeId, JSONObject nodeJson) {
        JSONObject oldNodeJson;
        JSONObject insertJson;
        if (nodeId == null) {
            DeerAnalyticsStore.writeGlobal(jobId, nodeJson);
            return;
        }
        String nodeName = nodeId.toString();
        JSONObject jobJson = backend.get(jobId);
        if (jobJson == null) {
            jobJson = new JSONObject();
            backend.put(jobId, jobJson);
        }
        if ((insertJson = jobJson.optJSONObject("operatorStats")) == null) {
            jobJson.put("operatorStats", (Object)new JSONObject());
            insertJson = jobJson.getJSONObject("operatorStats");
        }
        if ((oldNodeJson = insertJson.optJSONObject(nodeName)) == null) {
            insertJson.put(nodeName, (Object)nodeJson);
        } else {
            insertJson.put(nodeName, (Object)DeerAnalyticsStore.mergeJSONObjects(oldNodeJson, nodeJson));
        }
    }

    private static void writeGlobal(String jobId, JSONObject json) {
        JSONObject oldJson;
        JSONObject jobJson = backend.get(jobId);
        if (jobJson == null) {
            jobJson = new JSONObject();
            backend.put(jobId, jobJson);
        }
        if ((oldJson = jobJson.optJSONObject("globalStats")) == null) {
            jobJson.put("globalStats", (Object)json);
        } else {
            jobJson.put("globalStats", (Object)DeerAnalyticsStore.mergeJSONObjects(oldJson, json));
        }
    }

    public static synchronized JSONObject getAnalyticsForJob(String jobId) {
        return backend.get(jobId);
    }

    private static JSONObject mergeJSONObjects(JSONObject json1, JSONObject json2) {
        JSONObject mergedJSON;
        try {
            mergedJSON = new JSONObject(json1, JSONObject.getNames((JSONObject)json1));
            for (String crunchifyKey : JSONObject.getNames((JSONObject)json2)) {
                mergedJSON.put(crunchifyKey, json2.get(crunchifyKey));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON Exception" + e);
        }
        return mergedJSON;
    }
}

