/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.aksw.deer.ParameterizedDeerExecutionNode;
import org.aksw.deer.io.FileModelReader;
import org.aksw.deer.io.FileModelWriter;
import org.aksw.deer.learning.FitnessFunction;
import org.aksw.deer.vocabulary.DEERA;
import org.aksw.faraday_cage.decorator.AbstractParameterizedExecutionNodeDecorator;
import org.aksw.faraday_cage.engine.Parameterized;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;

public class TrainingData {
    private FitnessFunction fitnessFunciton;
    private List<String> trainingSourcePaths;
    private List<String> evaluationSourcePaths;
    private String trainingTargetPath;
    private String evaluationTargetPath;
    private String resultTargetPath;
    private List<Model> trainingSources;
    private List<Model> evaluationSources;
    private Model trainingTarget;
    private Model evaluationTarget;
    private List<ParameterizedDeerExecutionNode> trainingReaders;
    private List<ParameterizedDeerExecutionNode> evaluationReaders;
    private ParameterizedDeerExecutionNode resultWriter;

    public TrainingData(FitnessFunction fitnessFunciton, List<String> trainingSourcePaths, List<String> evaluationSourcePaths, String trainingTargetPath, String evaluationTargetPath, String resultTargetPath) {
        Model model;
        this.fitnessFunciton = fitnessFunciton;
        this.trainingSourcePaths = trainingSourcePaths;
        this.evaluationSourcePaths = evaluationSourcePaths;
        this.trainingTargetPath = trainingTargetPath;
        this.evaluationTargetPath = evaluationTargetPath;
        this.resultTargetPath = resultTargetPath;
        this.trainingSources = new ArrayList<Model>(trainingSourcePaths.size());
        this.trainingReaders = new ArrayList<ParameterizedDeerExecutionNode>(trainingSourcePaths.size());
        this.evaluationReaders = new ArrayList<ParameterizedDeerExecutionNode>(evaluationSourcePaths.size());
        for (String path : trainingSourcePaths) {
            model = ModelFactory.createDefaultModel().read(path);
            this.trainingSources.add(model);
            this.trainingReaders.add(this.getReaderFor(model, path));
        }
        this.evaluationSources = new ArrayList<Model>(evaluationSourcePaths.size());
        for (String path : evaluationSourcePaths) {
            model = ModelFactory.createDefaultModel().read(path);
            this.evaluationSources.add(model);
            this.evaluationReaders.add(this.getReaderFor(model, path));
        }
        this.trainingTarget = ModelFactory.createDefaultModel().read(trainingTargetPath);
        this.evaluationTarget = ModelFactory.createDefaultModel().read(evaluationTargetPath);
        this.resultWriter = this.getWriterFor(resultTargetPath);
    }

    private ParameterizedDeerExecutionNode getReaderFor(Model m, String path) {
        FileModelReader reader = new FileModelReader();
        reader.initPluginId(DEERA.forExecutionNode(reader));
        reader.initDegrees(0, 1);
        reader.initParameters(reader.createParameterMap().add(FileModelReader.FROM_PATH, (RDFNode)ResourceFactory.createStringLiteral((String)path)).init());
        return new NoOpModelReaderDecorator(reader, List.of(m));
    }

    private ParameterizedDeerExecutionNode getWriterFor(String path) {
        FileModelWriter writer = new FileModelWriter();
        writer.initPluginId(DEERA.forExecutionNode(writer));
        writer.initDegrees(1, 0);
        writer.initParameters(writer.createParameterMap().add(FileModelWriter.OUTPUT_FILE, (RDFNode)ResourceFactory.createStringLiteral((String)path)).init());
        return new NoOpModelWriterDecorator(writer);
    }

    public List<Model> getTrainingSources() {
        return this.trainingSources;
    }

    public List<String> getTrainingSourcePaths() {
        return this.trainingSourcePaths;
    }

    public List<String> getEvaluationSourcePaths() {
        return this.evaluationSourcePaths;
    }

    public Model getTrainingTarget() {
        return this.trainingTarget;
    }

    public Model getEvaluationTarget() {
        return this.evaluationTarget;
    }

    public String getTrainingTargetPath() {
        return this.trainingTargetPath;
    }

    public String getEvaluationTargetPath() {
        return this.evaluationTargetPath;
    }

    public String getResultTargetPath() {
        return this.resultTargetPath;
    }

    public ParameterizedDeerExecutionNode getResultWriter(Consumer<Model> callback) {
        return this.resultWriter;
    }

    public List<Model> getEvaluationSources() {
        return this.evaluationSources;
    }

    public List<ParameterizedDeerExecutionNode> getTrainingReaders() {
        return this.trainingReaders;
    }

    public List<ParameterizedDeerExecutionNode> getEvaluationReaders() {
        return this.evaluationReaders;
    }

    public FitnessFunction getFitnessFunction() {
        return this.fitnessFunciton;
    }

    private static class NoOpModelWriterDecorator
    extends AbstractParameterizedExecutionNodeDecorator<ParameterizedDeerExecutionNode, Model>
    implements ParameterizedDeerExecutionNode {
        private Consumer<Model> callback = m -> {};

        public NoOpModelWriterDecorator(ParameterizedDeerExecutionNode other) {
            super((Parameterized)other);
        }

        public List<Model> apply(List<Model> data) {
            this.callback.accept(data.get(0));
            return List.of();
        }

        public void setCallback(Consumer<Model> callback) {
            this.callback = callback;
        }
    }

    private static class NoOpModelReaderDecorator
    extends AbstractParameterizedExecutionNodeDecorator<ParameterizedDeerExecutionNode, Model>
    implements ParameterizedDeerExecutionNode {
        private List<Model> staticReturn;

        public NoOpModelReaderDecorator(ParameterizedDeerExecutionNode other, List<Model> staticReturn) {
            super((Parameterized)other);
            this.staticReturn = staticReturn;
        }

        public List<Model> apply(List<Model> data) {
            return this.staticReturn;
        }
    }
}

