/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.deer.learning.FitnessFunction;
import org.aksw.deer.learning.RandomUtil;
import org.aksw.deer.learning.genetic.Genotype;
import org.aksw.deer.learning.genetic.Mutator;
import org.aksw.deer.learning.genetic.Population;
import org.aksw.deer.learning.genetic.PopulationEvaluationResult;
import org.aksw.deer.learning.genetic.Recombinator;
import org.aksw.deer.learning.genetic.TournamentSelector;

public class GeneticProgrammingAlgorithm {
    private final Population startingPopulation;
    private final FitnessFunction fitnessFunction;
    private final TournamentSelector selector;
    private final List<Recombinator> recombinators;
    private final double offspringFraction;
    private final List<Mutator> mutators;
    private final double mutationProbability;
    private final double mutationRate;

    public GeneticProgrammingAlgorithm(Population startingPopulation, FitnessFunction fitnessFunction, TournamentSelector selector, List<Recombinator> recombinators, double offspringFraction, List<Mutator> mutators, double mutationProbability, double mutationRate) {
        this.fitnessFunction = fitnessFunction;
        this.mutationProbability = mutationProbability;
        this.mutationRate = mutationRate;
        this.mutators = mutators;
        this.recombinators = recombinators;
        this.offspringFraction = offspringFraction;
        this.startingPopulation = startingPopulation;
        this.selector = selector;
    }

    public List<PopulationEvaluationResult> run() {
        int generation = 0;
        int convergenceCounter = 0;
        double localMP = this.mutationProbability;
        double localMR = this.mutationRate;
        ArrayList<PopulationEvaluationResult> evolutionHistory = new ArrayList<PopulationEvaluationResult>();
        evolutionHistory.add(this.startingPopulation.evaluate(this.fitnessFunction));
        Population currentPopulation = this.startingPopulation;
        while (!this.mustTerminate(generation, ((PopulationEvaluationResult)evolutionHistory.get(generation)).getBest(), convergenceCounter)) {
            Genotype bestInGeneration = ((PopulationEvaluationResult)evolutionHistory.get(generation)).getBest();
            Population nextPopulation = new Population(1, () -> bestInGeneration);
            Population selectionPopulation = currentPopulation;
            nextPopulation.importPopulation((int)((double)currentPopulation.size() * this.offspringFraction), () -> {
                Genotype parent1 = this.selector.select(selectionPopulation);
                Genotype parent2 = this.selector.select(selectionPopulation);
                Genotype[] childs = this.getRecombinator().recombinate(parent1, parent2);
                return Arrays.asList(childs);
            });
            nextPopulation.fillPopulation(currentPopulation.size(), () -> {
                if (RandomUtil.get() < 0.5) {
                    return this.selector.select(selectionPopulation).compactBestResult(false, 0);
                }
                return this.selector.select(selectionPopulation).getEvaluatedCopy();
            });
            nextPopulation.evaluate(this.fitnessFunction);
            currentPopulation = nextPopulation.getMutatedPopulation(this::getMutator, localMP, localMR, g -> g == bestInGeneration);
            evolutionHistory.add(currentPopulation.evaluate(this.fitnessFunction));
            ++generation;
            if (localMP != this.mutationProbability) {
                localMP = Math.max(this.mutationProbability, localMP / 5.0 * 4.0);
            }
            if (localMR != this.mutationRate) {
                localMR = Math.max(this.mutationRate, localMR / 5.0 * 4.0);
            }
            if (!this.converged(evolutionHistory)) continue;
            ++convergenceCounter;
            localMP = 1.0;
            localMR = 1.0;
        }
        return evolutionHistory;
    }

    private boolean converged(List<PopulationEvaluationResult> history) {
        int lookAhead = 10;
        if (history.size() < lookAhead) {
            return false;
        }
        double f = history.get(history.size() - 1).getMax();
        for (int i = history.size() - lookAhead; i < history.size(); ++i) {
            if (history.get(i).getMax() == f && !(history.get(i).getStandardDeviation() > 0.1)) continue;
            return false;
        }
        return true;
    }

    private boolean mustTerminate(int generation, Genotype bestInGeneration, int convergenceCounter) {
        return generation >= 1999 || bestInGeneration.getBestFitness() == 1.0 || convergenceCounter == 5;
    }

    private Mutator getMutator() {
        return this.mutators.get(RandomUtil.get(this.mutators.size()));
    }

    private Recombinator getRecombinator() {
        return this.recombinators.get(RandomUtil.get(this.recombinators.size()));
    }
}

