/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.io;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.aksw.deer.ParameterizedDeerExecutionNode;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.AbstractParameterizedExecutionNode;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;

public abstract class AbstractModelIO
extends AbstractParameterizedExecutionNode<Model>
implements ParameterizedDeerExecutionNode {
    private static Supplier<String> workingDirectorySupplier = () -> "";

    public static void takeWorkingDirectoryFrom(Supplier<String> supplier) {
        if (supplier != null) {
            workingDirectorySupplier = supplier;
        }
    }

    public static String injectWorkingDirectory(String pathString) {
        Path path = Paths.get(pathString, new String[0]);
        Path currentDir = Paths.get(".", new String[0]);
        if (workingDirectorySupplier != null && path.isAbsolute()) {
            path = path.getFileName();
        }
        if (workingDirectorySupplier != null) {
            path = currentDir.resolve(workingDirectorySupplier.get()).resolve(path).normalize();
        }
        return path.toString();
    }

    public Model deepCopy(Model data) {
        return ModelFactory.createDefaultModel().add(data);
    }

    public Resource getType() {
        return DEER.resource(this.getClass().getSimpleName());
    }
}

