/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import java.util.List;
import org.aksw.deer.enrichments.AbstractParameterizedEnrichmentOperator;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.aksw.limes.core.measures.mapper.pointsets.OrthodromicDistance;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GeoDistanceEnrichmentOperator
extends AbstractParameterizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(GeoDistanceEnrichmentOperator.class);
    public static final Property SELECT_PREDICATE = DEER.property("selectPredicate");
    public static final Property DISTANCE_PREDICATE = DEER.property("distancePredicate");

    public ValidatableParameterMap createParameterMap() {
        return ValidatableParameterMap.builder().declareProperty(SELECT_PREDICATE).declareProperty(DISTANCE_PREDICATE).declareValidationShape(GeoDistanceEnrichmentOperator.getValidationModelFor(GeoDistanceEnrichmentOperator.class)).build();
    }

    protected List<Model> safeApply(List<Model> models) {
        Property selectPredicate = (Property)this.getParameterMap().get(SELECT_PREDICATE).as(Property.class);
        Property distancePredicate = (Property)this.getParameterMap().get(DISTANCE_PREDICATE).as(Property.class);
        models.get(0).listStatements(null, selectPredicate, (RDFNode)null).filterKeep(stmt -> stmt.getObject().isResource()).toList().forEach(stmt -> this.enrichWithDistance((Statement)stmt, (Model)models.get(0), distancePredicate));
        return models;
    }

    private void enrichWithDistance(Statement stmt, Model model, Property distancePredicate) {
        String ns = "http://www.w3.org/2003/01/geo/wgs84_pos#";
        Property lat = model.createProperty("http://www.w3.org/2003/01/geo/wgs84_pos#", "lat");
        Property lon = model.createProperty("http://www.w3.org/2003/01/geo/wgs84_pos#", "long");
        double aLat = stmt.getSubject().getProperty(lat).getDouble();
        double aLong = stmt.getSubject().getProperty(lon).getDouble();
        double bLat = stmt.getObject().asResource().getProperty(lat).getDouble();
        double bLong = stmt.getObject().asResource().getProperty(lon).getDouble();
        stmt.getSubject().addProperty(distancePredicate, OrthodromicDistance.getDistanceInDegrees((double)aLat, (double)aLong, (double)bLat, (double)bLong) + "km");
    }
}

