/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeX<T> {
    private List<TreeX<T>> children = null;
    private List<TreeX<T>> parents;
    private T value;
    private boolean isPrinted = false;

    public TreeX(List<TreeX<T>> parents, T value, List<TreeX<T>> childrenlist) {
        this.value = value;
        if (parents != null) {
            for (TreeX<T> parent : parents) {
                this.addParent(parent);
            }
        }
        if (childrenlist != null) {
            for (TreeX<T> child : childrenlist) {
                this.addChild(child);
            }
        }
    }

    public TreeX(TreeX<T> root) {
        this(root.parents, root.value, root.children);
    }

    public TreeX(TreeX<T> parent, T value, List<TreeX<T>> childrenlist) {
        if (parent != null) {
            this.addParent(parent);
        }
        this.value = value;
        if (childrenlist != null) {
            for (TreeX<T> child : childrenlist) {
                this.addChild(child);
            }
        }
    }

    public TreeX(List<TreeX<T>> parents, T value, TreeX<T> child) {
        this.value = value;
        for (TreeX<T> parent : parents) {
            this.addParent(parent);
        }
        if (child != null) {
            this.addChild(child);
        }
    }

    public TreeX(T value) {
        this.parents = null;
        this.value = value;
        this.children = null;
    }

    public TreeX() {
        this.children = null;
        this.parents = null;
        this.value = null;
    }

    public static void main(String[] args) {
    }

    public List<TreeX<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeX<T>> children) {
        this.children = children;
    }

    public Set<TreeX<T>> getLeaves() {
        HashSet<TreeX<T>> leaves = new HashSet<TreeX<T>>();
        for (TreeX<T> child : this.children) {
            if (child.children == null) {
                leaves.add(child);
                continue;
            }
            Set<TreeX<T>> childrenLeaves = child.getLeaves();
            for (TreeX<T> l : childrenLeaves) {
                leaves.add(l);
            }
        }
        return leaves;
    }

    public TreeX<T> addChild(TreeX<T> child) {
        if (this.children == null) {
            this.children = new ArrayList<TreeX<T>>();
        }
        if (child.parents == null) {
            child.parents = new ArrayList<TreeX<T>>();
        }
        this.children.add(child);
        child.parents.add(this);
        return child;
    }

    public TreeX<T> addParent(TreeX<T> parent) {
        if (this.parents == null) {
            this.parents = new ArrayList<TreeX<T>>();
        }
        this.parents.add(parent);
        if (parent.children == null) {
            parent.children = new ArrayList<TreeX<T>>();
        }
        if (!parent.children.contains(this)) {
            parent.children.add(this);
        }
        return parent;
    }

    public void removeChild(TreeX<T> child) {
        this.children.remove(child);
    }

    public TreeX<T> getParent() {
        return this.parents.get(0);
    }

    public void setParent(TreeX<T> parent) {
        if (this.parents == null) {
            this.parents = new ArrayList<TreeX<T>>();
        }
        this.parents.set(0, parent);
        if (parent.children == null) {
            parent.children = new ArrayList<TreeX<T>>();
        }
        parent.children.add(this);
    }

    public List<TreeX<T>> getParents() {
        return this.parents;
    }

    public void setParents(List<TreeX<T>> parents) {
        this.parents = parents;
    }

    public List<TreeX<T>> getchildren() {
        return this.children;
    }

    public T getValue() {
        return this.value;
    }

    public void print() {
        this.unsetPrintFlag();
        this.print("", true);
    }

    private void unsetPrintFlag() {
        this.isPrinted = false;
        if (this.children != null) {
            for (TreeX<T> child : this.children) {
                child.unsetPrintFlag();
            }
        }
    }

    private void print(String prefix, boolean isTail) {
        if (!this.isPrinted) {
            String value = this.parents == null || this.parents.isEmpty() ? "ROOT(\u27c2)" : this.value;
            boolean isMerge = false;
            String branch = "";
            if (isTail) {
                if (this.parents != null && this.parents.size() > 1) {
                    branch = "\u2560\u2550\u2550 ";
                    isMerge = true;
                } else {
                    branch = "\u2514\u2500\u2500 ";
                }
            } else {
                branch = "\u251c\u2500\u2500 ";
            }
            System.out.println(prefix + branch + value);
            this.isPrinted = true;
            if (this.children != null) {
                for (int i = 0; i < this.children.size() - 1; ++i) {
                    this.children.get(i).print(prefix + (isTail ? (isMerge ? "\u2551   " : "    ") : "\u2502   "), false);
                }
                if (this.children.size() > 0) {
                    this.children.get(this.children.size() - 1).print(prefix + (isTail ? (isMerge ? "\u2551   " : "    ") : "\u2502   "), true);
                }
            }
        }
    }

    public long size() {
        long size = 0L;
        if (this.children == null || this.children.size() == 0) {
            return 1L;
        }
        for (TreeX<T> child : this.children) {
            size += child.size();
        }
        return 1L + size;
    }

    public long depth() {
        if (this.children == null || this.children.size() == 0) {
            return 1L;
        }
        long maxDepth = 0L;
        for (TreeX<T> child : this.children) {
            long d = child.depth();
            if (maxDepth >= d) continue;
            maxDepth = d;
        }
        return maxDepth + 1L;
    }

    public long level() {
        long level = 0L;
        TreeX<T> t = this;
        while (t.parents != null) {
            ++level;
            t = t.parents.get(0);
        }
        return level;
    }
}

