/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.old_learning;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.aksw.deer.ParameterizedDeerExecutionNode;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefinementNode
implements Comparable<RefinementNode> {
    private static final Logger logger = LoggerFactory.getLogger(RefinementNode.class);
    public ParameterizedDeerExecutionNode module = null;
    public ParameterizedDeerExecutionNode operator = null;
    public double fitness = -1.7976931348623157E308;
    public List<Model> inputModels = new ArrayList<Model>();
    public List<Model> outputModels = new ArrayList<Model>();
    public Model configModel = ModelFactory.createDefaultModel();
    public List<Resource> inputDatasets = new ArrayList<Resource>();
    public List<Resource> outputDatasets = new ArrayList<Resource>();

    private RefinementNode(ParameterizedDeerExecutionNode module, ParameterizedDeerExecutionNode operator, double fitness, List<Model> inputModels, List<Model> outputModels, Model configModel, List<Resource> inputDatasets, List<Resource> outputDatasets) {
        if (module != null && operator != null) {
            logger.error("RefinementNodeX can contain either a enrichments or an operator not both. Exit with error!");
            System.exit(1);
        }
        this.module = module;
        this.operator = operator;
        this.fitness = fitness;
        this.inputModels = inputModels;
        this.outputModels = outputModels;
        this.configModel = configModel;
        this.inputDatasets = inputDatasets;
        this.outputDatasets = outputDatasets;
        if (configModel != null) {
            configModel.setNsPrefix("deer", "http://w3id.org/deer/");
        }
    }

    public RefinementNode(ParameterizedDeerExecutionNode operator, double fitness, List<Model> inputModels, List<Model> outputModels, Model configModel, List<Resource> inputDatasets, List<Resource> outputDatasets) {
        this(null, operator, fitness, inputModels, outputModels, configModel, inputDatasets, outputDatasets);
    }

    private RefinementNode(ParameterizedDeerExecutionNode module, ParameterizedDeerExecutionNode operator, double fitness, Model inputModel, Model outputModel, Model configModel, Resource inputDataset, Resource outputDataset) {
        if (module != null && operator != null) {
            logger.error("RefinementNodeX can contain either a enrichments or an operator not both. Exit with error!");
            System.exit(1);
        }
        this.module = module;
        this.operator = operator;
        this.fitness = fitness;
        this.inputModels.add(inputModel);
        this.outputModels.add(outputModel);
        this.configModel = configModel;
        this.inputDatasets.add(inputDataset);
        this.outputDatasets.add(outputDataset);
        if (configModel != null) {
            configModel.setNsPrefix("deer", "http://w3id.org/deer/");
        }
    }

    public RefinementNode(ParameterizedDeerExecutionNode module, double fitness, Model inputModel, Model outputModel, Model configModel, Resource inputDataset, Resource outputDataset) {
        this(module, null, fitness, inputModel, outputModel, configModel, inputDataset, outputDataset);
    }

    public RefinementNode() {
        this.configModel.setNsPrefix("deer", "http://w3id.org/deer/");
    }

    public RefinementNode(double fitness) {
        this();
        this.fitness = fitness;
    }

    public static void main(String[] args) {
    }

    public String toString() {
        String format = new DecimalFormat("#.###").format(this.fitness);
        if (this.module != null) {
            return this.module.getClass().getSimpleName().replace("Module", "") + "(" + format + ")";
        }
        if (this.operator != null) {
            return this.operator.getClass().getSimpleName().toUpperCase().replace("OPERATOR", "") + "(" + format + ")";
        }
        return "invalid node";
    }

    @Override
    public int compareTo(RefinementNode o) {
        return (int)(this.fitness - o.fitness);
    }

    public Model getOutputModel() {
        return this.outputModels.get(0);
    }

    public Model getInputModel() {
        return this.inputModels.get(0);
    }

    public Resource getOutputDataset() {
        return this.outputDatasets.get(0);
    }

    public Resource getInputDataset() {
        return this.inputDatasets.get(0);
    }
}

