/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.List;
import org.aksw.deer.enrichments.EnrichmentOperator;
import org.aksw.deer.learning.RandomUtil;
import org.aksw.deer.learning.ReverseLearnable;
import org.aksw.deer.learning.genetic.AbstractMutator;
import org.aksw.deer.learning.genetic.Genotype;
import org.aksw.deer.learning.genetic.RandomOperatorFactory;
import org.apache.jena.rdf.model.Model;

public class SimpleSemanticMutator
extends AbstractMutator {
    @Override
    protected void mutateRow(Genotype g, int i) {
        List<EnrichmentOperator> all = RandomOperatorFactory.getAll();
        double[] applicabilities = new double[all.size()];
        boolean[] getFirst = new boolean[all.size()];
        double sum = 0.0;
        Model target = g.trainingData.getTrainingTarget();
        for (int k = 0; k < all.size(); ++k) {
            EnrichmentOperator op = all.get(k);
            List<Model> inputModels = g.getInputModels(i);
            if (inputModels.size() > op.getInDegree()) {
                double applicability1 = ((ReverseLearnable)((Object)op)).predictApplicability(List.of(inputModels.get(0)), target);
                double applicability2 = ((ReverseLearnable)((Object)op)).predictApplicability(List.of(inputModels.get(1)), target);
                applicabilities[k] = Math.max(applicability1, applicability2);
                getFirst[k] = applicability1 >= applicability2;
            } else {
                applicabilities[k] = inputModels.size() == op.getInDegree() ? ((ReverseLearnable)((Object)op)).predictApplicability(inputModels, target) : ((ReverseLearnable)((Object)op)).predictApplicability(List.of(inputModels.get(0), inputModels.get(0)), target);
            }
            sum += applicabilities[k];
        }
        double lo = 0.0;
        double hi = 0.0;
        double rand = RandomUtil.get();
        int bestK = 0;
        for (int k = 0; k < all.size(); ++k) {
            lo = hi;
            hi += applicabilities[k] / sum;
            if (!(lo <= rand) || !(hi > rand)) continue;
            bestK = k;
            break;
        }
        EnrichmentOperator op = all.get(bestK);
        List<Integer> inputs = g.getInputs(i);
        if (inputs.size() > op.getInDegree()) {
            if (getFirst[bestK]) {
                g.addRow(i, op, new int[]{1, 1, inputs.get(0), 0});
            } else {
                g.addRow(i, op, new int[]{1, 1, inputs.get(1), 0});
            }
        } else if (inputs.size() < op.getInDegree()) {
            g.addRow(i, op, new int[]{2, 1, inputs.get(0), 0, inputs.get(0), 0});
        } else if (inputs.size() == 2) {
            g.addRow(i, op, new int[]{2, 1, inputs.get(0), 0, inputs.get(1), 0});
        } else {
            g.addRow(i, op, new int[]{1, 1, inputs.get(0), 0});
        }
    }
}

