/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.List;
import java.util.function.Consumer;
import org.aksw.deer.DeerExecutionNode;
import org.aksw.deer.ParameterizedDeerExecutionNode;
import org.aksw.deer.decorators.AbstractDeerExecutionNodeDecorator;
import org.aksw.deer.decorators.AbstractParameterizedDeerExecutionNodeDecorator;
import org.aksw.deer.learning.EvaluationResult;
import org.aksw.deer.learning.SelfConfigurable;
import org.aksw.faraday_cage.engine.ExecutionNode;
import org.aksw.faraday_cage.engine.Parameterized;
import org.aksw.faraday_cage.engine.ValidatableParameterMap;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SelfConfigurationWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SelfConfigurationWrapper.class);

    private SelfConfigurationWrapper() {
    }

    static DeerExecutionNode wrap(DeerExecutionNode executionNode, Consumer<EvaluationResult> callback, Model target) {
        if (executionNode instanceof Parameterized) {
            return new SelfConfigurationDecorator((ParameterizedDeerExecutionNode)executionNode, callback, target);
        }
        return new LearningDecorator(executionNode, callback, target);
    }

    private static class SelfConfigurationDecorator
    extends AbstractParameterizedDeerExecutionNodeDecorator {
        private final Consumer<EvaluationResult> callback;
        private final Model target;

        public SelfConfigurationDecorator(ParameterizedDeerExecutionNode other, Consumer<EvaluationResult> callback, Model target) {
            super(other);
            this.callback = callback;
            this.target = target;
        }

        public List<Model> apply(List<Model> in) {
            ValidatableParameterMap parameterMap = ((SelfConfigurable)this.getWrapped()).learnParameterMap(in, this.target, null);
            ((ParameterizedDeerExecutionNode)this.getWrapped()).initParameters(parameterMap);
            List out = super.apply(in);
            this.callback.accept(new EvaluationResult((Model)out.get(0), this.target));
            return out;
        }
    }

    private static class LearningDecorator
    extends AbstractDeerExecutionNodeDecorator {
        private final Consumer<EvaluationResult> callback;
        private final Model target;

        public LearningDecorator(ExecutionNode<Model> other, Consumer<EvaluationResult> callback, Model target) {
            super(other);
            this.callback = callback;
            this.target = target;
        }

        public List<Model> apply(List<Model> in) {
            List out = super.apply(in);
            this.callback.accept(new EvaluationResult((Model)out.get(0), this.target));
            return out;
        }
    }
}

