/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning.genetic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.aksw.deer.learning.FitnessFunction;
import org.aksw.deer.learning.RandomUtil;
import org.aksw.deer.learning.genetic.Genotype;
import org.aksw.deer.learning.genetic.Mutator;
import org.aksw.deer.learning.genetic.PopulationEvaluationResult;
import org.aksw.faraday_cage.engine.ThreadlocalInheritingCompletableFuture;

public class Population {
    private List<Genotype> backingList;
    private PopulationEvaluationResult evaluationResult = null;

    Population(int size, Supplier<Genotype> genotypeSupplier) {
        this(size);
        this.fillPopulation(size, genotypeSupplier);
    }

    Population(int size) {
        this.backingList = new ArrayList<Genotype>(size);
    }

    Population(Population population) {
        this.backingList = new ArrayList<Genotype>(population.backingList);
    }

    public PopulationEvaluationResult evaluate(FitnessFunction f) {
        if (Objects.isNull(this.evaluationResult)) {
            CompletableFuture joiner = ThreadlocalInheritingCompletableFuture.completedFuture(null);
            this.backingList.stream().map(g -> g.getBestEvaluationResult(f)).reduce(joiner, (g, h) -> g.thenCombine((CompletionStage)h, (x, y) -> null)).join();
            this.evaluationResult = new PopulationEvaluationResult(this.backingList);
        }
        return this.evaluationResult;
    }

    public void importPopulation(int limit, Supplier<Collection<Genotype>> genotypeSupplier) {
        while (this.backingList.size() < limit) {
            this.backingList.addAll(genotypeSupplier.get());
        }
    }

    public void fillPopulation(int limit, Supplier<Genotype> genotypeSupplier) {
        while (this.backingList.size() < limit) {
            this.backingList.add(genotypeSupplier.get());
        }
        this.backingList = new ArrayList<Genotype>(this.backingList);
    }

    public Population getMutatedPopulation(Supplier<Mutator> mutator, double mutationProbability, double mutationRate, Predicate<Genotype> exclude) {
        Population mutated = new Population(this.backingList.size());
        this.backingList.forEach(g -> mutated.backingList.add(RandomUtil.get() < mutationProbability && !exclude.test((Genotype)((Object)g)) ? ((Mutator)mutator.get()).mutate((Genotype)((Object)g), mutationRate) : g));
        return mutated;
    }

    public Genotype getRandomGenotype() {
        return this.backingList.get(RandomUtil.get(this.backingList.size()));
    }

    public int size() {
        return this.backingList.size();
    }
}

