/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.learning;

import java.util.Set;
import java.util.function.Function;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;

public class EvaluationResult {
    public static final String HEADER = "precision_subjects, precision_predicates, precision_objects, precision_triples, recall_subjects, recall_predicates, recall_objects, recall_triples";
    private double[] recall = new double[4];
    private double[] precision = new double[4];
    private Model selected;

    public EvaluationResult(Model selected, Model relevant) {
        this.selected = selected;
        Function<Model, Set> s = m -> m.listSubjects().filterDrop(RDFNode::isAnon).toSet();
        Function<Model, Set> p = m -> m.listStatements().mapWith(Statement::getPredicate).toSet();
        Function<Model, Set> o = m -> m.listObjects().filterDrop(RDFNode::isAnon).toSet();
        Function<Model, Set> t = m -> m.listStatements().filterDrop(stmt -> stmt.getObject().isAnon() || stmt.getSubject().isAnon()).toSet();
        this.computePR(0, s.apply(selected), s.apply(relevant));
        this.computePR(1, p.apply(selected), p.apply(relevant));
        this.computePR(2, o.apply(selected), o.apply(relevant));
        this.computePR(3, t.apply(selected), t.apply(relevant));
    }

    private void computePR(int i, Set<?> s, Set<?> t) {
        long truePositives = s.stream().filter(t::contains).count();
        this.precision[i] = (double)truePositives / (double)s.size();
        this.recall[i] = (double)truePositives / (double)t.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringHelper(sb, this.precision);
        this.toStringHelper(sb, this.recall);
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private void toStringHelper(StringBuilder sb, double[] evaluationMetric) {
        sb.append(evaluationMetric[0]);
        sb.append(",");
        sb.append(evaluationMetric[1]);
        sb.append(",");
        sb.append(evaluationMetric[2]);
        sb.append(",");
        sb.append(evaluationMetric[3]);
        sb.append(",");
    }

    public double[] getIndividualFMeasures(double beta) {
        double[] result = new double[4];
        double alpha = Math.pow(beta, 2.0);
        for (int i = 0; i < result.length; ++i) {
            if (this.precision[i] + this.recall[i] == 0.0) continue;
            result[i] = (1.0 + alpha) * (this.precision[i] * this.recall[i]) / (alpha * this.precision[i] + this.recall[i]);
        }
        return result;
    }

    public Model getResultModel() {
        return this.selected;
    }

    public double[] getIndividualRecall() {
        return this.recall;
    }

    public double[] getIndividualPrecision() {
        return this.precision;
    }
}

