/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer;

import org.aksw.deer.DeerPlugin;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.Analytics;
import org.aksw.faraday_cage.CompletableFutureFactory;
import org.aksw.faraday_cage.ExecutionFactory;
import org.aksw.faraday_cage.ExecutionGraph;
import org.aksw.faraday_cage.ExecutionGraphGenerator;
import org.aksw.faraday_cage.PluginFactory;
import org.aksw.faraday_cage.Vocabulary;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.jena.rdf.model.Model;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deer {
    private static final Logger logger = LoggerFactory.getLogger(Deer.class);

    public void run(Model config, PluginManager pluginManager, CompletableFutureFactory futureFactory) {
        Vocabulary.setDefaultURI((String)DEER.getURI());
        StopWatch time = new StopWatch();
        logger.info("Building execution model...");
        time.start();
        PluginFactory deerFactory = new PluginFactory(DeerPlugin.class, pluginManager);
        time.split();
        logger.trace("Factory initialized after {}ms.", (Object)time.getSplitTime());
        ExecutionGraph executionGraph = new ExecutionGraphGenerator(config).generate();
        time.split();
        logger.trace("Execution graph built after {}ms.", (Object)time.getSplitTime());
        executionGraph.compile((ExecutionFactory)deerFactory, futureFactory);
        time.split();
        logger.info("Execution graph compiled after {}ms.", (Object)time.getSplitTime());
        logger.info("Starting execution of enrichment...");
        Analytics analytics = executionGraph.execute();
        time.split();
        logger.info("Enrichment finished after {}ms", (Object)time.getSplitTime());
        logger.info("Analytics information:\n------------------------------------------\n{}", (Object)analytics.toString());
    }
}

