/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.deer.enrichments.AuthorityConformationEnrichmentOperator;
import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.faraday_cage.parameter.conversions.DictListParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PredicateConformationEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityConformationEnrichmentOperator.class);
    private static final Property SOURCE = Vocabulary.property((String)"source");
    private static final Property TARGET = Vocabulary.property((String)"target");
    private static final Parameter PROPERTY_MAPPING = new ParameterImpl("propertyMapping", (ParameterConversion)new DictListParameterConversion(new Property[]{SOURCE, TARGET}), true);
    private List<Map<Property, RDFNode>> propertyMapping = new ArrayList<Map<Property, RDFNode>>();

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        ParameterMap result = this.createParameterMap();
        ArrayList propertyDictList = new ArrayList();
        source.listStatements().forEachRemaining(s -> {
            StmtIterator targetIt = target.listStatements(s.getSubject(), null, s.getObject());
            if (targetIt.hasNext()) {
                HashMap<Property, Resource> nodeMap = new HashMap<Property, Resource>();
                nodeMap.put(SOURCE, s.getPredicate().asResource());
                nodeMap.put(TARGET, ((Statement)targetIt.next()).getPredicate().asResource());
                propertyDictList.add(nodeMap);
            }
        });
        result.setValue(PROPERTY_MAPPING, propertyDictList);
        return result;
    }

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{PROPERTY_MAPPING});
    }

    protected List<Model> safeApply(List<Model> models) {
        Model model = models.get(0);
        Model conformModel = ModelFactory.createDefaultModel();
        StmtIterator statmentsIter = model.listStatements();
        while (statmentsIter.hasNext()) {
            Statement statment = statmentsIter.nextStatement();
            Resource s = statment.getSubject();
            Property p = statment.getPredicate();
            RDFNode o = statment.getObject();
            Property replacement = this.findReplacement(p);
            conformModel.add(s, replacement != null ? replacement : p, o);
        }
        model = conformModel;
        return Lists.newArrayList((Object[])new Model[]{model});
    }

    private Property findReplacement(Property p) {
        Property[] result = new Property[]{null};
        this.propertyMapping.forEach(nodeMap -> {
            if (((RDFNode)nodeMap.get(SOURCE)).equals(p)) {
                result[0] = (Property)((RDFNode)nodeMap.get(TARGET)).as(Property.class);
            }
        });
        return result[0];
    }

    public void validateAndAccept(@NotNull ParameterMap parameterMap) {
        this.propertyMapping = (List)parameterMap.getValue(PROPERTY_MAPPING);
    }
}

