/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.deer.enrichments.MergeEnrichmentOperator;
import org.aksw.faraday_cage.nodes.Node;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.limes.core.controller.Controller;
import org.aksw.limes.core.controller.LSPipeline;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class LinkingEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(LinkingEnrichmentOperator.class);
    private static final Parameter SPEC_FILE = new ParameterImpl("specFile", false);
    private static final Parameter SELECT_MODE = new ParameterImpl("selectMode", false);
    private static final Parameter LINKS_PART = new ParameterImpl("linksPart", false);
    private static final Parameter LINK_SPECIFICATION = new ParameterImpl("linkSpecification", false);
    private static final Parameter LINKING_PREDICATE = new ParameterImpl("linkingPredicate", false);
    private static final Parameter THRESHOLD = new ParameterImpl("threshold", false);
    private String specFile;
    private SELECT selectMode;
    private DATASET_PART linksPart;
    private String linkSpecification;
    private String linkingPredicate;
    private double threshold;

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{SPEC_FILE, LINKS_PART, SELECT_MODE, LINK_SPECIFICATION, LINKING_PREDICATE, THRESHOLD});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.specFile = (String)params.getValue(SPEC_FILE);
        this.linksPart = DATASET_PART.valueOf(((String)params.getValue(LINKS_PART, (Object)"source")).toUpperCase());
        this.selectMode = SELECT.valueOf(((String)params.getValue(SELECT_MODE, (Object)"all")).toUpperCase());
        this.linkSpecification = (String)params.getValue(LINK_SPECIFICATION);
        this.linkingPredicate = (String)params.getValue(LINKING_PREDICATE);
        this.threshold = Double.parseDouble(((String)params.getValue(THRESHOLD, (Object)"0.9")).replaceAll("\\^\\^.*$", ""));
    }

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        return ParameterMap.EMPTY_INSTANCE;
    }

    protected List<Model> safeApply(List<Model> models) {
        if (models.size() == 1) {
            Model model = this.setPrefixes(models.get(0));
            Configuration cfg = new XMLConfigurationReader(this.specFile).read();
            if (this.getOutDegree() == 1) {
                this.addLinksToModel(model, this.getMappingFromConfiguration(cfg));
                return Lists.newArrayList((Object[])new Model[]{model});
            }
            Model linkModel = ModelFactory.createDefaultModel();
            this.addLinksToModel(linkModel, this.getMappingFromConfiguration(cfg));
            return Lists.newArrayList((Object[])new Model[]{model, linkModel});
        }
        ACache source = this.modelToCache(models.get(0));
        ACache target = this.modelToCache(models.get(1));
        AMapping mapping = LSPipeline.execute((ACache)source, (ACache)target, (LinkSpecification)new LinkSpecification(this.linkSpecification, this.threshold));
        mapping = this.applySelectModeToMapping(mapping);
        if (this.getOutDegree() == 1) {
            this.addLinksToModel(models.get(0), mapping);
            return new MergeEnrichmentOperator().safeApply(models);
        }
        if (this.getOutDegree() == 2) {
            this.addLinksToModel(models.get(this.linksPart == DATASET_PART.SOURCE ? 0 : 1), mapping);
            return models;
        }
        Model linkModel = ModelFactory.createDefaultModel();
        this.addLinksToModel(linkModel, mapping);
        return Lists.newArrayList((Object[])new Model[]{models.get(0), models.get(1), linkModel});
    }

    @Override
    public Node.DegreeBounds getDegreeBounds() {
        return new Node.DegreeBounds(1, 2, 1, 3);
    }

    private Model setPrefixes(Model model) {
        String gn = "http://www.geonames.org/ontology#";
        String owl = "http://www.w3.org/2002/07/owl#";
        model.setNsPrefix("gn", gn);
        model.setNsPrefix("owl", owl);
        return model;
    }

    private AMapping getMappingFromConfiguration(Configuration cfg) {
        AMapping mapping = Controller.getMapping((Configuration)cfg).getAcceptanceMapping();
        return this.applySelectModeToMapping(mapping);
    }

    private AMapping applySelectModeToMapping(AMapping mapping) {
        AMapping result = mapping;
        switch (this.selectMode) {
            case BEST: {
                HashMap reversedMap = mapping.getReversedMap();
                double best = 0.0;
                for (Double sim : reversedMap.keySet()) {
                    if (!(sim > best)) continue;
                    Map.Entry entry = ((HashMap)reversedMap.get(sim)).entrySet().iterator().next();
                    result = MappingFactory.createDefaultMapping();
                    result.add((String)entry.getKey(), (String)((TreeSet)entry.getValue()).first(), sim.doubleValue());
                }
                break;
            }
            case BEST1TO1: {
                result = mapping.getBestOneToOneMappings(mapping);
                break;
            }
            case BEST1TON: {
                result = mapping.getBestOneToNMapping();
            }
        }
        this.writeAnalytics("#discovered links", "" + result.size());
        return result;
    }

    private void addLinksToModel(Model model, AMapping mapping) {
        Property predicate = model.createProperty(this.linkingPredicate);
        for (String s : mapping.getMap().keySet()) {
            Resource subject = model.createResource(s);
            for (String t : ((HashMap)mapping.getMap().get(s)).keySet()) {
                Resource object = model.createResource(t);
                if (this.linksPart == DATASET_PART.SOURCE) {
                    model.add(subject, predicate, (RDFNode)object);
                    continue;
                }
                model.add(object, predicate, (RDFNode)subject);
            }
        }
    }

    private ACache modelToCache(Model m) {
        MemoryCache cache = new MemoryCache();
        m.listStatements().filterDrop(stmt -> stmt.getObject().isAnon()).forEachRemaining(arg_0 -> LinkingEnrichmentOperator.lambda$modelToCache$1((ACache)cache, arg_0));
        return cache;
    }

    private static /* synthetic */ void lambda$modelToCache$1(ACache cache, Statement stmt) {
        cache.addTriple(stmt.getSubject().getURI(), stmt.getPredicate().getURI(), stmt.getObject().toString());
    }

    private static enum SELECT {
        BEST,
        BEST1TO1,
        BEST1TON,
        ALL;

    }

    private static enum DATASET_PART {
        SOURCE,
        TARGET;

    }
}

