/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.faraday_cage.nodes.Node;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.StringParameterConversion;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.vocabulary.OWL;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GeoFusionEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(GeoFusionEnrichmentOperator.class);
    private static final Parameter FUSION_ACTION = new ParameterImpl("fusionAction");
    private static final Parameter MERGE_OTHER_STATEMENTS = new ParameterImpl("mergeOtherStatements", (ParameterConversion)StringParameterConversion.getInstance(), false);
    private GeoFusionAction fusionAction;
    private boolean mergeOtherStatements;

    protected List<Model> safeApply(List<Model> models) {
        logger.info("Invoking GeoFusionOperator of {} models with fusionAction {} and mergeOtherStatements {}", new Object[]{models.size(), this.fusionAction, this.mergeOtherStatements});
        GeoFusionAction action = this.fusionAction;
        if (!models.get(0).contains(null, OWL.sameAs)) {
            logger.info("No owl:sameAs statements detected in first model, attempting to swap model A and model B");
            Model temp = models.get(1);
            models.set(1, models.get(0));
            models.set(0, temp);
        }
        Model targetModel = ModelFactory.createDefaultModel();
        ArrayList visitedResources = Lists.newArrayList();
        ResIterator subjects = models.get(0).listSubjects();
        while (subjects.hasNext()) {
            Resource subject = (Resource)subjects.next();
            List<Resource> sameAsResources = this.getSameAsResources(models.get(0), subject);
            List<CandidateGeometry> candidateGeometries = this.getCandidateGeometries(models.get(0), models.get(1), subject, sameAsResources);
            this.fuseCandidateGeometries(models.get(0), models.get(1), subject, sameAsResources, candidateGeometries, action, this.mergeOtherStatements, targetModel);
            visitedResources.add(subject);
            visitedResources.addAll(sameAsResources);
        }
        this.addNonVisitedResources(models.get(1), targetModel, visitedResources, this.mergeOtherStatements);
        return Lists.newArrayList((Object[])new Model[]{targetModel});
    }

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        ParameterMap result = this.createParameterMap();
        result.setValue(FUSION_ACTION, (Object)GeoFusionAction.takeMostDetailed.name());
        result.setValue(MERGE_OTHER_STATEMENTS, (Object)"true");
        return result;
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.fusionAction = GeoFusionAction.valueOf((String)params.getValue(FUSION_ACTION));
        this.mergeOtherStatements = Boolean.valueOf((String)params.getValue(MERGE_OTHER_STATEMENTS, (Object)"true"));
    }

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{FUSION_ACTION, MERGE_OTHER_STATEMENTS});
    }

    @Override
    public Node.DegreeBounds getDegreeBounds() {
        return new Node.DegreeBounds(2, 2, 1, 1);
    }

    private void fuseCandidateGeometries(Model model, Model model2, Resource subject, List<Resource> sameAsResources, List<CandidateGeometry> candidateGeometries, GeoFusionAction action, boolean mergeOtherStatements, Model targetModel) {
        Model droppedGeometries;
        CandidateGeometry selectedCandidateGeometry = this.selectCandidateGeometry(model, candidateGeometries, subject, action);
        if (selectedCandidateGeometry != null) {
            // empty if block
        }
        Model model3 = droppedGeometries = action.equals((Object)GeoFusionAction.takeAll) ? ModelFactory.createDefaultModel() : this.getDroppedGeometries(candidateGeometries, selectedCandidateGeometry);
        if (!mergeOtherStatements) {
            StmtIterator geometryStatements = selectedCandidateGeometry.getGeometryModel().listStatements();
            while (geometryStatements.hasNext()) {
                Statement statement = (Statement)geometryStatements.next();
                targetModel.add(subject, statement.getPredicate(), statement.getObject());
            }
            return;
        }
        StmtIterator subjectStatements = model.listStatements(subject, null, (RDFNode)null);
        while (subjectStatements.hasNext()) {
            Statement statement = (Statement)subjectStatements.next();
            if (droppedGeometries.contains(statement)) continue;
            targetModel.add(statement);
        }
        for (Resource sameAsResource : sameAsResources) {
            StmtIterator sameAsStatements = model2.listStatements(sameAsResource, null, (RDFNode)null);
            while (sameAsStatements.hasNext()) {
                Statement statement = (Statement)sameAsStatements.next();
                if (droppedGeometries.contains(statement)) continue;
                targetModel.add(subject, statement.getPredicate(), statement.getObject());
            }
        }
    }

    private void addNonVisitedResources(Model model2, Model targetModel, List<Resource> visitedResources, boolean mergeOtherStatements) {
        List nonVisitedSubjects = model2.listSubjects().toList();
        nonVisitedSubjects.removeAll(visitedResources);
        for (Resource nonVisitedSubject : nonVisitedSubjects) {
            if (mergeOtherStatements) {
                targetModel.add(model2.listStatements(nonVisitedSubject, null, (RDFNode)null));
                continue;
            }
            Model geometryModel = this.getGeometry(model2, nonVisitedSubject);
            targetModel.add(geometryModel);
        }
    }

    private CandidateGeometry selectCandidateGeometry(Model model, List<CandidateGeometry> candidateGeometries, Resource subject, GeoFusionAction action) {
        CandidateGeometry selected = null;
        int score = -1;
        if (action.equals((Object)GeoFusionAction.takeAll)) {
            Model mergedGeometries = ModelFactory.createDefaultModel();
            for (CandidateGeometry candidateGeometry : candidateGeometries) {
                mergedGeometries.add(candidateGeometry.geometryModel);
            }
            return new CandidateGeometry(subject, mergedGeometries);
        }
        for (CandidateGeometry candidateGeometry : candidateGeometries) {
            int candidateScore;
            boolean isFromA = candidateGeometry.subject.equals((Object)subject);
            if (action.equals((Object)GeoFusionAction.takeA) && isFromA) {
                return candidateGeometry;
            }
            if (action.equals((Object)GeoFusionAction.takeB) && isFromA || (candidateScore = this.computeCandidateScore(model, candidateGeometry)) <= score) continue;
            score = candidateScore;
            selected = candidateGeometry;
        }
        return selected;
    }

    private Model getDroppedGeometries(List<CandidateGeometry> candidateGeometries, CandidateGeometry selectedCandidateGeometry) {
        Model droppedGeometriesModel = ModelFactory.createDefaultModel();
        for (CandidateGeometry candidateGeometry : candidateGeometries) {
            if (candidateGeometry.getSubject().equals((Object)selectedCandidateGeometry.getSubject())) continue;
            droppedGeometriesModel.add(candidateGeometry.getGeometryModel());
        }
        return droppedGeometriesModel;
    }

    private int computeCandidateScore(Model model, CandidateGeometry candidateGeometry) {
        NodeIterator latitudeNodes = candidateGeometry.getGeometryModel().listObjectsOfProperty(null, (Property)new PropertyImpl(model.expandPrefix("geo:lat")));
        NodeIterator longitudeNodes = candidateGeometry.getGeometryModel().listObjectsOfProperty(null, (Property)new PropertyImpl(model.expandPrefix("geo:long")));
        int latScore = -1;
        int longScore = -1;
        while (latitudeNodes.hasNext()) {
            RDFNode latitudeNode = latitudeNodes.next();
            try {
                latScore = latitudeNode.asLiteral().getLexicalForm().length();
            }
            catch (Exception e) {
                logger.warn("Unexpected issue parsing latitude literal node " + latitudeNode, (Throwable)e);
            }
        }
        if (latScore == -1) {
            logger.warn("No latitude node found in {}, returning score -1", (Object)candidateGeometry);
            return -1;
        }
        while (longitudeNodes.hasNext()) {
            RDFNode longitudeNode = longitudeNodes.next();
            try {
                longScore = longitudeNode.asLiteral().getLexicalForm().length();
            }
            catch (Exception e) {
                logger.warn("Unexpected issue parsing longitude literal node " + longitudeNode, (Throwable)e);
            }
        }
        if (longScore == -1) {
            logger.warn("No longitude node found in {}, returning score -1", (Object)candidateGeometry);
            return -1;
        }
        return latScore + longScore;
    }

    private Model getGeometry(Model model, Resource subject) {
        List latitudes = model.listStatements(subject, (Property)new PropertyImpl(model.expandPrefix("geo:lat")), (RDFNode)null).toList();
        List longitudes = model.listStatements(subject, (Property)new PropertyImpl(model.expandPrefix("geo:long")), (RDFNode)null).toList();
        return ModelFactory.createDefaultModel().add(latitudes).add(longitudes);
    }

    private List<CandidateGeometry> getCandidateGeometries(Model sourceA, Model sourceB, Resource subject, List<Resource> sameAsResources) {
        ArrayList candidateGeometries = Lists.newArrayList();
        Model sourceAGeometry = this.getGeometry(sourceA, subject);
        if (!sourceAGeometry.isEmpty()) {
            candidateGeometries.add(new CandidateGeometry(subject, sourceAGeometry));
        }
        for (Resource sameAs : sameAsResources) {
            Model sameAsGeometry = this.getGeometry(sourceB, sameAs);
            if (sameAsGeometry.isEmpty()) continue;
            candidateGeometries.add(new CandidateGeometry(sameAs, sameAsGeometry));
        }
        return candidateGeometries;
    }

    private List<Resource> getSameAsResources(Model sourceA, Resource subject) {
        return sourceA.listObjectsOfProperty(subject, OWL.sameAs).filterKeep(RDFNode::isURIResource).mapWith(RDFNode::asResource).toList();
    }

    private static class CandidateGeometry {
        private final Resource subject;
        private final Model geometryModel;

        CandidateGeometry(Resource subject, Model geometryModel) {
            this.subject = subject;
            this.geometryModel = geometryModel;
        }

        Resource getSubject() {
            return this.subject;
        }

        Model getGeometryModel() {
            return this.geometryModel;
        }

        public String toString() {
            return "CandidateGeometry [subject=" + this.subject + ", geometryModel=" + this.geometryModel + "]";
        }
    }

    public static enum GeoFusionAction {
        takeA,
        takeB,
        takeAll,
        takeMostDetailed;

    }
}

