/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import java.util.List;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.limes.core.measures.mapper.pointsets.OrthodromicDistance;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GeoDistanceEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(GeoDistanceEnrichmentOperator.class);
    private static final Parameter SELECT_PREDICATE = new ParameterImpl("selectPredicate");
    private static final Parameter DISTANCE_PREDICATE = new ParameterImpl("distancePredicate");
    private Property selectPredicate;
    private Property distancePredicate;

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{SELECT_PREDICATE, DISTANCE_PREDICATE});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.selectPredicate = ResourceFactory.createProperty((String)((String)params.getValue(SELECT_PREDICATE)));
        this.distancePredicate = ResourceFactory.createProperty((String)((String)params.getValue(DISTANCE_PREDICATE)));
    }

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        return ParameterMap.EMPTY_INSTANCE;
    }

    protected List<Model> safeApply(List<Model> models) {
        models.get(0).listStatements(null, this.selectPredicate, (RDFNode)null).filterKeep(stmt -> stmt.getObject().isResource()).toList().forEach(stmt -> this.enrichWithDistance((Statement)stmt, (Model)models.get(0)));
        return models;
    }

    private void enrichWithDistance(Statement stmt, Model model) {
        String ns = "http://www.w3.org/2003/01/geo/wgs84_pos#";
        Property lat = model.createProperty("http://www.w3.org/2003/01/geo/wgs84_pos#", "lat");
        Property lon = model.createProperty("http://www.w3.org/2003/01/geo/wgs84_pos#", "long");
        double aLat = stmt.getSubject().getProperty(lat).getDouble();
        double aLong = stmt.getSubject().getProperty(lon).getDouble();
        double bLat = stmt.getObject().asResource().getProperty(lat).getDouble();
        double bLong = stmt.getObject().asResource().getProperty(lon).getDouble();
        stmt.getSubject().addProperty(this.distancePredicate, OrthodromicDistance.getDistanceInDegrees((double)aLat, (double)aLong, (double)bLat, (double)bLong) + "km");
    }
}

